fcf.module({
  name: "fcf:NSystem/NPackage/Theme.js",
  dependencies: ["fcf:NSystem/NPackage/tools.js"],
  module: function(libTools){
    let Namespace = fcf.prepareObject(fcf, "NSystem/NPackage");

    class Theme {
      constructor(a_name, a_configutaion) {
        this._name          = a_name;
        this._configuration = a_configutaion;
        this.rebuild();
      }

      rebuild(){
        this._selfConfiguration = fcf.append(true, {}, {
          aliases:     fcf.application.getConfiguration().aliases,
          decor:       fcf.application.getConfiguration().decor,
          usageViews:  fcf.application.getConfiguration().usageViews,
          defaultArgs: fcf.application.getConfiguration().defaultArgs,
        });
        libTools.mergeConfiguration(this._selfConfiguration, this._configuration, false);

        this._decor         = typeof this._selfConfiguration.decor == "object" ? this._selfConfiguration.decor : {};
        this._aliases       = typeof this._selfConfiguration.aliases == "object" ? this._selfConfiguration.aliases : {};
        this.setAliases(this._aliases);
      }

      getName(){
        return this._name;
      }

      getConfiguration() {
        return this._selfConfiguration;
      }

      getDecor(){
        return this._decor;
      }

      getInfo(){
        return this._selfConfiguration;
      }

      getAliases() {
        return this._aliases;
      }

      resolveAlias(a_path) {
        if (a_path.charAt(0) != "@")
          return a_path;
        let subpart = a_path.split("+")[1];
        a_path = a_path.split("+")[0];
        let alias = a_path.substr(1);
        let aliases = this.getAliases();
        let result = alias in aliases ? aliases[alias] : a_path;
        if (subpart)
          result += "+" + subpart;
        return result;
      }

      setAliases(a_aliases) {
        for(let key in a_aliases){
          let alias = key[0] == "@" ? key.substr(1) : key;
          this._aliases[alias] = a_aliases[key];
        }
      }

    };

    Namespace.Theme = Theme;

    return Namespace.Theme;
  }
});
