fcf.module({
  name:         "fcfBackup:templates/management/backup+body.wrapper.js",
  dependencies: ["fcfManagement:templates/pages/base.wrapper.js"],
  module: function(Wrapper){
    return class WrapperImpl extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onArg_config(a_value, a_editor, a_ignoreRedrawing, a_innerCall, a_suffix){
        if (!this.getArg("_modify")) {
          this.setArg("_modify", true);
        }
      }

      async onSave() {
        this.setArg("_modify", false);
        this.lock();
        try{
          await this.send({type: "save_config", config: this.getArg("_config")});
        } catch(error) {
          fcf.application.getEventChannel().send("fcf_error", error);
        } finally {
          this.unlock();
        }
        this.update();
      }

      async createBackup(){
        this.lock();
        try{
          await this.send({type: "create_backup"});
        } catch(error) {
          fcf.application.getEventChannel().send("fcf_error", error);
        } finally {
          this.unlock();
        }
      }

    };
  }
});
