fcf.module({
  name: "fcfControls:templates/file-edit.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(Wrapper){
    return class WrapperEx extends Wrapper{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._file = document.createElement("input");
        this._file.type = "file";
        this._file.addEventListener("change", (a_event)=>{ this.onFileChange(a_event); });
      }

      destroy(){
        super.destroy();
        this._file = null;
      }

      attach(a_options){
        if (this._file.value)
          this.setArg("file",  this._file, false, true);
        super.attach(a_options);
      }

      onFileSelect(){
        this._file.click();
      }

      onFileClear(a_event){
        this.setArg("file",  null);
        this.setArg("fileAlias", null);
        this._file.value = "";
      }

      onFileChange(a_event){
        if (!this._file.value){
          this.onFileClear();
          return;
        }

        let fileName = this.getArg("uniqueFileName")
                        ? fcf.getShortFileName(this._file.value)  + "-" + fcf.uuid() + (fcf.getExtension(this._file.value) ? "." + fcf.getExtension(this._file.value) : "")
                        : fcf.getFileName(this._file.value);
        this._file.name = fileName;
        this._file.path = fileName;
        this._file.setAttribute("filename", fileName);
        this.setArg("file", this._file);
        this.setArg("fileAlias", fcf.getFileName(this._file.value));
      }

    };
  }
});
