fcf.module({
  name: "fcfManagement:templates/pages/main+body.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      hooksProgrammableArgument: {
        //
        // @result Returns the value of an argument or a Promise object
        //
        items: async (a_taskInfo)=>{
          function getInfoNode(a_node){
            if (a_node.endpoint && a_node.endpoint.controller == "fcf:NServer/NControllers/Page.js"){
              return {
                uri: a_node.uri,
                title: a_node.endpoint.sectionTitle ? a_node.endpoint.sectionTitle : a_node.title,
                description: a_node.endpoint.description,
              };
            }
            for(let part in a_node.parts){
              let info = getInfoNode(a_node.parts[part]);
              if (info)
                return info;
            }

          }
          let items = [];
          let tree  = await fcf.application.getRouter().getNode("/fcfpackages/fcfManagement", 2);
          for(let key in tree.node.parts){
            let info = getInfoNode(tree.node.parts[key]);
            if (info)
              items.push(info);
          }
          return items;
        }
      },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },
    };
  }
});
