let libFS = require("fs");
let libPath = require("path");
let libUtil = require("util");
let libChildProcess = require("child_process");

fcf.module({
  name:         "fcf:update.js",
  dependencies: [],
  lazy:         [],
  module: function(){
    return class Update {

      async "1.1.36"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
      }

      async "1.1.37-a6"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
        fcf.log.log("FCF", `fcfnode ${require.main.filename} --clear-duplicates`);
        await libUtil.promisify(libChildProcess.exec)(`fcfnode ${require.main.filename} --clear-duplicates`, {env: process.env});
      }

      async "1.1.38-a8"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});

        fcf.log.log("FCF", `Clearing translate projections`);
        let dir = fcf.getPath(fcf.application.getConfiguration().directorySystemProjections);
        let files = await libUtil.promisify(libFS.readdir)(dir);
        for (const file of files) {
          if ((await libUtil.promisify(libFS.lstat)(libPath.join(dir, file))).isDirectory())
            continue;
          await libUtil.promisify(libFS.unlink)(libPath.join(dir, file));
        }

        fcf.log.log("FCF", `fcfnode ${require.main.filename} --clear-duplicates`);
        await libUtil.promisify(libChildProcess.exec)(`fcfnode ${require.main.filename} --clear-duplicates`, {env: process.env});
      }

      async "1.1.37-a8"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
      }

      async "1.1.42-a"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
      }

      async "1.1.43-a"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
      }

      async "1.1.55"() {
        await libUtil.promisify(libChildProcess.exec)("fcfmngr clear-cache", {env: process.env});
      }

    };
  }
});
