/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Method;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;

public abstract class BindingMethod {
    protected ClassFile m_classFile;

    protected BindingMethod(ClassFile cf) {
        this.m_classFile = cf;
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public abstract String getName();

    public abstract String getSignature();

    public abstract int getAccessFlags();

    public abstract void setAccessFlags(int var1);

    public abstract Method getMethod();

    public abstract ClassItem getItem();

    public void makeAccessible(ClassFile src) {
        int access = this.getAccessFlags();
        if ((access & 1) == 0) {
            ClassFile dest = this.getClassFile();
            if (dest.getPackage().equals(src.getPackage())) {
                if ((access & 2) != 0) {
                    access -= 2;
                }
            } else {
                ClassFile ancestor = src;
                while ((ancestor = ancestor.getSuperFile()) != null && ancestor != dest) {
                }
                if (ancestor == null) {
                    int clear = 6;
                    access = access & ~clear | 1;
                } else if ((access & 4) == 0) {
                    access = access & 0xFFFFFFFD | 4;
                }
            }
            if (access != this.getAccessFlags()) {
                this.setAccessFlags(access);
            }
        }
    }

    public static int computeMethodHash(Method method) {
        int i;
        int hash = method.getSignature().hashCode();
        ExceptionTable etab = method.getExceptionTable();
        if (etab != null) {
            String[] excepts = etab.getExceptionNames();
            for (i = 0; i < excepts.length; ++i) {
                hash += excepts[i].hashCode();
            }
        }
        byte[] code = method.getCode().getCode();
        for (i = 0; i < code.length; ++i) {
            hash = hash * 49 + code[i];
        }
        return hash;
    }

    public abstract int hashCode();

    public boolean equals(Object obj) {
        if (obj instanceof BindingMethod) {
            BindingMethod comp = (BindingMethod)obj;
            if (this.hashCode() == comp.hashCode() && this.getSignature().equals(comp.getSignature())) {
                return ClassFile.equalMethods(this.getMethod(), comp.getMethod());
            }
        }
        return false;
    }
}

