/*
 * $Id: ContextAccessor.java,v 1.12 2005/12/25 23:36:16 sugimotokenichi Exp $
 * 쐬: 2005/3/17
 */
package feat.v1;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import feat.v1.config.CommandDeclaration;
import feat.v1.config.FeatConfig;
import feat.v1.config.FeatureDeclaration;

/**
 * ReLXgւ̃ANZX𓝈ꂷ邽߂̃NXB
 * @author SUGIMOTO Ken-ichi
 */
public class ContextAccessor {

    // static -------------------------------------------------------

    protected static Log log = LogFactory.getLog(ContextAccessor.class);

    public static final int
    		SCOPE_PARAM = 1,
            SCOPE_REQUEST = 2,
            SCOPE_SESSION = 3,
            SCOPE_APPLICATION = 4;

    static FeatConfig getFeatConfig(ServletContext sctx) throws FeatException {
        FeatConfig conf = (FeatConfig)sctx.getAttribute(FeatConst.CONFIG_KEY);
        if ( conf == null )
            throw new FeatException("FeatConfig擾łȂ", FeatException.LEVEL_FATAL);
        return conf;
    }

    static void setFeatConfig(ServletContext sctx, FeatConfig config) {
        sctx.setAttribute(FeatConst.CONFIG_KEY, config);
        sctx.setAttribute(FeatConst.CONFIG_LASTUPDATE_KEY, new Long(System.currentTimeMillis()));
    }

    static long getConfigLastUpdateTime(ServletContext sctx) {
        return ((Long)sctx.getAttribute(FeatConst.CONFIG_LASTUPDATE_KEY)).longValue();
    }


    // instance -----------------------------------------------------

    private ServletContext servletContext;
    private FeatConfig config;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private FeatureDeclaration currentFeature;
    private CommandDeclaration currentCommand;
    private FeatureErrors errs;
    private Exception exception;

    /**
     *
     * @param servletContext ServletContext
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @param featureName ݂̃NGXg̃tB[`[BNGXgURIoB
     * @param commandName ݂̃NGXg̃R}hBNGXgURIoB
     * @param createSession ZbVKvɂȂƂɎIɐVKZbV쐬ȂtrueB
     *         falsew肷HttpSessionKvȃ\bhĂяoƂHTTPSessionExceptionX[B
     * @throws FeatException FeatConfigIuWFNgAtB[`[`܂̓R}h`Ȃ
     */
    public ContextAccessor(ServletContext servletContext,
                           HttpServletRequest request,
                           HttpServletResponse response,
                           String featureName,
                           String commandName) throws FeatException {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;

        // p[^`FbN
        // ŃCX^X̗Ỏ\ɗ͂Ȃ
        config = getFeatConfig(servletContext);
        currentFeature = config.getFeatureDeclaration(featureName);
        if ( currentFeature == null )
            throw new FeatException("tB[`[擾łȂ:"+featureName, FeatException.LEVEL_WARN);
        currentCommand = currentFeature.getCommand(commandName);
        if ( currentCommand == null )
            throw new FeatException("R}h擾łȂ:"+commandName, FeatException.LEVEL_WARN);

        String enc = getEncoding();
        try {
            if ( enc != null )
                request.setCharacterEncoding(enc);
        }
        catch (UnsupportedEncodingException ex) {
            log.warn("T|[gĂȂGR[fBO:enc", ex);
        }
        errs = new FeatureErrors();
    }


    public HttpServletRequest getRequest() {
        return request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public ServletContext getServletContext() {
        return servletContext;
    }

    public FeatConfig getFeatConfig() {
        return config;
    }
    void setFeatConfig(FeatConfig config) {
        this.config = config;
        setFeatConfig(servletContext, config);
    }

    public FeatureDeclaration getCurrentFeatureDeclaration() {
        return currentFeature;
    }

    public CommandDeclaration getCurrentCommandDeclaration() {
        return currentCommand;
    }

    public HttpSession getSession() throws HTTPSessionException {
        HttpSession session = request.getSession(getCurrentFeatureDeclaration().isCreateSession());
        if ( session == null ) {
            throw new HTTPSessionException("HttpSessionȂ");
        }
        return session;
    }

    /**
     * ̃NGXg̏ɔG[̃XgԂB
     * @return FeatureErrors
     */
    public FeatureErrors getFeatureErrors() {
        return errs;
    }

    /**
     * NGXgp[^̖Oi[zԂB
     * NGXgp[^Ȃꍇ͋̔zԂB
     * @return
     */
    public String[] getParameterNames() {
        Enumeration e = request.getParameterNames();
        ArrayList ret = new ArrayList();
        while ( e.hasMoreElements() ) {
            String name = (String)e.nextElement();
            ret.add(name);
        }
        if ( ret.size() == 0 )
            return new String[0];
        else
            return (String[])ret.toArray(new String[ret.size()]);
    }

    /**
     * NGXgp[^̒lԂB
     * p[^ɕ̒l܂܂Ƃ͍ŏ̈ԂB
     * @param name
     * @return p[^Ƃnull
     * @see javax.servlet.ServletRequest#getParameter(java.lang.String)    */
    public String getParameter(String name) {
        return request.getParameter(name);
    }

    /**
     * NGXgp[^̒lԂB
     * @param name
     * @return
     * @see javax.servlet.ServletRequest#getParameterValues(java.lang.String)
     */
    public String[] getParameterValues(String name) {
        return request.getParameterValues(name);
    }

    /**
     * wpX̃IuWFNgMapC^tF[XŃbvĕԂB
     * "param"w肷ƃNGXgp[^̃}bv(lString[]^)A
     * ȊÔƂ̓IuWFNg̃vpeB̃}bvԂB
     * IuWFNg̃pX "XR[v:.vpeB̃pX" ̌`B
     * vpeB̃pX͖ĂǂB
     * @param path "param"܂getAttribute(String)ɓnpX(paramXR[vȊO)
     * @return wpX̃IuWFNg̃vpeB}bv
     * @throws ContextAttributeAccessException paramXR[v̌ɑw肵B
     *      	܂݂͑ȂXR[vw肵B
     * @throws HTTPSessionException ZbVJnłȂ
     */
    public Map getMappedValue(String path) throws ContextAttributeAccessException, HTTPSessionException {
        if ( path.startsWith("param") ) {
            if ( !path.equals("param") )
                throw new ContextAttributeAccessException("łparamXR[vɑwłȂ - path:"+path, FeatException.LEVEL_ERROR);
            return request.getParameterMap();
        }
        else {
            return ObjectUtil.getBeanMap(getAttribute(path));
        }
    }

    /**
     * 擾B
     * XR[vSCOPE_PARAMw肵Ƃ͒P̒l̂ݎ擾łB
     * NGXgp[^̒lꍇ͍ŏ̈ԂB
     * @param scope SCOPE_PARAM, SCOPE_REQUEST, SCOPE_SESSION, SCOPE_APPLICATION̒萔̂ǂꂩB
     * @param name ̖O
     * @return ̒lBOɑΉlȂnullԂ
     * @throws HTTPSessionException ZbVJnłȂ
     * @throws ContextAttributeAccessException ݂ȂXR[vw肵
     */
    public Object getAttribute(int scope, String name) throws
            HTTPSessionException, ContextAttributeAccessException {
        // Agr[g̃IuWFNgo
        Object o = null;
        switch(scope) {
            case SCOPE_PARAM:
                o = request.getParameter(name);
                break;
            case SCOPE_REQUEST:
                o = request.getAttribute(name);
                break;
            case SCOPE_SESSION:
                o = getSession().getAttribute(name);
                break;
            case SCOPE_APPLICATION:
                o = servletContext.getAttribute(name);
                break;
            default:
                throw new ContextAttributeAccessException("scope = "+scope, FeatException.LEVEL_ERROR);
        }
        return o;
    }

    /**
     * 擾B<br>
     * lXgOwł̂ŁAIuWFNgc[̒Cӂ̃IuWFNg擾邱ƂłB<br>
     * Ⴆ <br>
     * ((Foo)session.getAttribute("user")).getName().getFirstName();<br>
     * ́Ã\bhł<br>
     * getAttribute(SCOPE_SESSION, "user", "name.firstName");<br>
     * ƏƂłB
     * @param scope SCOPE_PARAM, SCOPE_REQUEST, SCOPE_SESSION, SCOPE_APPLICATION̒萔̂ǂꂩB
     * @param name ̖O
     * @param path IuWFNg̃vpeBBlXgOłǂB
     * @throws HTTPSessionException ZbVJnłȂ
     * @throws ContextAttributeAccessException ݂ȂXR[vw肵
     * @return ̒lBOɑΉlȂnullԂ
     */
    public Object getAttribute(int scope, String name, String path) throws
            HTTPSessionException, ContextAttributeAccessException {

        // Agr[g̃IuWFNgo
        Object o = getAttribute(scope, name);

        if ( o != null ) {
            // lXgOvpeBo
            try {
                o = ObjectUtil.getProperty(o, path);
            }
            catch (NoSuchMethodException e) {
                throw new ContextAttributeAccessException(e, FeatException.LEVEL_ERROR);
            }
            catch (InvocationTargetException e) {
                throw new ContextAttributeAccessException(e, FeatException.LEVEL_ERROR);
            }
            catch (IllegalAccessException e) {
                throw new ContextAttributeAccessException(e, FeatException.LEVEL_ERROR);
            }
        }

        return o;
    }

    /**
     * 擾B<br>
     * lXgOwł̂ŁAIuWFNgc[̒Cӂ̃IuWFNg擾邱ƂłB<br>
     * Ⴆ <br>
     * ((Foo)session.getAttribute("user")).getName().getFirstName();<br>
     * ́Ã\bhł<br>
     * getAttribute("session:user.name.firstName");<br>
     * ƏƂłB
     * @param path "XR[v:"
     * @throws HTTPSessionException ZbVJnłȂ
     * @throws ContextAttributeAccessException ݂ȂXR[vw肵
     * @return Object
     */
    public Object getAttribute(String path)
            throws ContextAttributeAccessException, HTTPSessionException {

        int colonIndex = path.indexOf(':');
        if ( colonIndex < 1 ) {
            throw new ContextAttributeAccessException("XR[vw肳ĂȂ", FeatException.LEVEL_ERROR);
        } else {
            // XR[vo
            String scope = path.substring(0, colonIndex);

            // XR[v𐔒lɂ
            int intScope = -1;
            if ( scope.equalsIgnoreCase("param") )
                intScope = SCOPE_PARAM;
            else if ( scope.equalsIgnoreCase("request") )
                intScope = SCOPE_REQUEST;
            else if ( scope.equalsIgnoreCase("session") )
                intScope = SCOPE_SESSION;
            else if ( scope.equalsIgnoreCase("application") )
                intScope = SCOPE_APPLICATION;
            else
                throw new ContextAttributeAccessException("XR[vȂ: "+scope, FeatException.LEVEL_ERROR);

            // ̃pXođlԂ
            // ̃pX'.'܂܂Ă瑮Ƃȍ~̃pXɕ
            int dotIndex = path.indexOf('.', colonIndex);
            if ( dotIndex > -1 ) {
                String attrName = path.substring(colonIndex+1, dotIndex);
                String objectPath = path.substring(dotIndex+1);
                return getAttribute(intScope, attrName, objectPath);
            }
            else {
                String attrName = path.substring(colonIndex+1);
                return getAttribute(intScope, attrName);
            }
        }
    }

    /**
     * ZbgB
     * @param scope SCOPE_REQUEST, SCOPE_SESSION, SCOPE_APPLICATION̒萔̂ǂꂩB
     * @param name ̖O
     * @param value ̒l
     */
    public void setAttribute(int scope, String name, Object value) throws
            HTTPSessionException, ContextAttributeAccessException {

        switch(scope) {
            case SCOPE_REQUEST:
                request.setAttribute(name, value);
                break;
            case SCOPE_SESSION:
                getSession().setAttribute(name, value);
                break;
            case SCOPE_APPLICATION:
                servletContext.setAttribute(name, value);
                break;
            default:
                throw new ContextAttributeAccessException("scope = "+scope, FeatException.LEVEL_ERROR);
        }
    }

    /**
     * ݂̃P[̃\[XԂB
     * @param name String
     * @return String
     */
    public String getStringResource(String name) {
        return getStringResource(getCurrentFeatureDeclaration(), name);
    }

    /**
     * wtB[`[烊\[X擾B
     * P[HTTPZbVɕۑꂽݒAHTTPwb_Accept-Language瓾ꂽ̂gpB
     * @see #setLocale(Locale)
     * @see #getLocale()
     */
    public String getStringResource(FeatureDeclaration featureDecl, String name) {
        return getStringResource(featureDecl, name, getLocale());
    }

    /**
     * \[X擾B
     */
    public String getStringResource(FeatureDeclaration featureDecl, String name, Locale locale) {
        // w̃P[ŃANZXł錾ꖼ擾
        List sequence = Util.makeSequence(locale);

        // uP[wȂvǉ
        sequence.add(Util.NULL_LOCALE);

        // }b`郊\[XT
        for(int i=0; i<sequence.size(); i++) {
            // tB[`[̃\[X
            String ret = featureDecl.getStringResource(name, (Locale)sequence.get(i));
            // TODO FeatConfig̃\[X

            if ( ret != null )
                return ret;
        }
        return null;
    }

    /**
     * ݂̃GR[fBOݒԂB
     * GR[fBO̓NGXgp[^擾ƂɎQƂB
     * R}hAtB[`[̏ŌBǂɂ`ĂȂƂnullB
     * @return String
     */
    public String getEncoding() {
        String ret = null;

        ret = getCurrentCommandDeclaration().getEncoding();

        if (ret == null) {
            ret = getCurrentFeatureDeclaration().getEncoding();
        }

        return ret;
    }

    /**
     * ̃ZbṼP[ύXB
     * @param locale
     */
    public void setLocale(Locale locale) throws HTTPSessionException {
        getSession().setAttribute(FeatConst.FEATURE_CONTEXT_LOCALE_KEY, locale);
    }

    /**
     * ݂̃XR[ṽP[擾B
     * P[̌ ZbV -> HTTPwb_(Accept-Language) -> JVM̃ftHgP[B
     * @return
     */
    public Locale getLocale() {
        Locale ret = null;
        try {
            ret = (Locale)getSession().getAttribute(FeatConst.FEATURE_CONTEXT_LOCALE_KEY);
        }
        catch (HTTPSessionException ex) {
        }

        FeatureDeclaration featureDec = getCurrentFeatureDeclaration();

        // P[`Ɋ܂߂̂͂H
        // P[̓[UG[WFgŵŃAvP[VŒ`̂ł͂ȂB
        // tB[`[`feat-config.xml̃P[̓P[񂪓ȂƂ
        // ftHgP[ɂƗǂB
        /*
        if ( ret == null && featureDec != null )
            ret = featureDec.getLocale();
        if ( ret == null )
            ret = context.getFeatConfig().getLocale();
         */

        // HTTPwb_̃P[߂
        if ( ret == null && request != null ) {
            String acceptLanguage = request.getHeader("Accept-Language");
            if ( acceptLanguage != null && acceptLanguage.length() > 0 ) {
                LanguageRange[] languageRange = parseLanguageRange(
                        acceptLanguage);
                if ( languageRange.length > 0 ) {
                    ret = languageRange[0].lang;
                }
            }
        }

        if ( ret == null )
            ret = Locale.getDefault();


        return ret;
    }

    private LanguageRange[] parseLanguageRange(String str) {
        String list[] = StringUtil.stripAll(StringUtil.split(str, ","));
        LanguageRange[] ret = new LanguageRange[list.length];
        for(int i=0; i<list.length; i++) {
            ret[i] = new LanguageRange(list[i], i);
        }
        Arrays.sort(ret);
        return ret;
    }


    private class LanguageRange implements Comparable {
        Locale lang;
        double quality;
        int index;

        LanguageRange(String str, int index) {
            this.index = index;

            if ( str == null || str.length() == 0 ) {
                lang = null;
                quality = 0.0D;
                return;
            }

            String[] part = StringUtil.stripAll(StringUtil.split(str, ";"));
            if ( part.length != 0 ) {
                lang = parseLang(part[0]);
                if ( part.length > 1 ) {
                    String[] token = StringUtil.stripAll(StringUtil.split(part[1], "="));
                    if ( token.length > 1 ) {
                        quality = parseQuality(token[1]);
                    }
                }
                else {
                    quality = 1.0D;
                }
            }
        }

        private Locale parseLang(String str) {
            Locale ret = null;
            if ( str != null && str.length() > 0 ) {
                String[] l = StringUtil.split(str, "-");
                if ( l.length == 1 ) {
                    ret = new Locale(l[0].toLowerCase());
                }
                else if ( l.length >= 2 ) {
                    ret = new Locale(l[0].toLowerCase(), l[1].toUpperCase());
                }
            }
            return ret;
        }

        private double parseQuality(String token) {
            try {
                return Double.parseDouble(token);
            }
            catch (NumberFormatException ex) {
                return 0.0D;
            }
        }

        public int compareTo(Object o) {
            return -compareTo_(o);
        }

        private int compareTo_(Object o) {
            LanguageRange oo = (LanguageRange)o;
            if ( quality < oo.quality )
                return -1;
            if ( quality > oo.quality )
                return 1;

            if ( index < oo.index )
                return -1;
            if ( index > oo.index )
                return 1;

            return 0;
        }
    }

    /**
     * NGXg̏ɋNOZbgB
     * @param ex
     */
    public void setException(Exception ex) {
        exception = ex;
    }

    /**
     * NGXg̏ɋNOԂB
     * @return
     */
    public Exception getException() {
        return exception;
    }

}
