/*
 * $Id: FeatException.java,v 1.3 2005/05/22 14:58:43 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 */

package feat.v1;

public class FeatException extends Exception {

    /** [UZbVAEFuAvP[V𑱍słG[ */
    public static final int LEVEL_WARN = 1;
    /** [UZbV𑱍słȂA܂̓X|XԂƂłȂ炢̃G[ */
    public static final int LEVEL_ERROR = 2;
    /** EFuAvP[V𑱍słȂ炢̃G[ */
    public static final int LEVEL_FATAL = 3;

    private int level;

    public FeatException(Throwable cause, int level) {
        super(cause);
        this.level = level;
    }

    public FeatException(String message, int level) {
        super(message);
        this.level = level;
    }

    public FeatException(String message, Throwable cause, int level) {
        super(message, cause);
        this.level = level;
    }

    public FeatException(Throwable cause) {
        super(cause);
        this.level = LEVEL_ERROR;
    }

    public FeatException(String message) {
        super(message);
        this.level = LEVEL_ERROR;
    }

    public FeatException(String message, Throwable cause) {
        super(message, cause);
        this.level = LEVEL_ERROR;
    }

    public int getLevel() {
        return level;
    }
}
