/*
 * $Revision: 1.3 $ $Date: 2005/09/08 01:32:34 $
 * (C) 2004 SUGIMOTO Ken-ichi
 */

package feat.v1;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;

import feat.v1.template.HTMLDocument;

public class PageResponse implements Response {

    private HTMLDocument doc;
    private String encoding;

    public PageResponse(HTMLDocument doc, String encoding) {
        this.doc = doc;
        this.encoding = encoding;
    }

    public void output(ContextAccessor acc) throws ServletException {
        HttpServletResponse response = acc.getResponse();
        response.setContentType("text/html;charset="+encoding);
        try {
            response.getWriter().write(doc.toHTML());
        }
        catch (IOException ex) {
            throw new ServletException(ex);
        }
    }

}
