/*
 * $Id: ExceptionDeclaration.java,v 1.1 2005/05/22 14:58:43 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/05/09
 */
package feat.v1.config;

import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;
import feat.v1.ObjectUtil;
import feat.v1.ResponsePointer;
import feat.v1.Util;

/**
 * O̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class ExceptionDeclaration implements ConfigElement {

    public static final String
    	LOG_FATAL = "fatal",
    	LOG_ERROR = "error",
    	LOG_WARN = "warn",
    	LOG_INFO = "info",
    	LOG_DEBUG = "debug",
    	LOG_TRACE = "trace";

    private Class typeClass;
    private FeatureDeclaration featureDecl;
    private ResponsePointer responsePointer;

    // JiBX
    private String type;
    private String response;
    private String log;
    private String logMessage;

    public Class getType() {
        return typeClass;
    }

    public String getName() {
        return type;
    }

    /**
     * Oo͂̃xBnull̂Ƃ̓Oo͂ȂB
     * @return
     */
    public String getLog() {
        return log;
    }

    public String getLogMessage() {
        return logMessage;
    }

    public ResponsePointer getResponsePointer() {
        return responsePointer;
    }

    public FeatureDeclaration getFeatureDeclaration() {
        return featureDecl;
    }

    public void postset(IUnmarshallingContext uctx) {
        featureDecl = (FeatureDeclaration)uctx.getStackObject(1);
    }

    public void init() throws InitializationException {
        responsePointer = Util.parseResponseName(response, getFeatureDeclaration().getName());
    }

    public void validate() throws InitializationException {
        FeatConfig cfg = getFeatureDeclaration().getFeatureConfig().getFeatConfig();
        try {
            typeClass = ObjectUtil.loadClass(type, getFeatureDeclaration().getPackage());

            ResponseDeclaration responseDecl = cfg.getFeatureDeclaration(responsePointer.getFeatureName())
	            									  .getResponseDeclaration(responsePointer.getName());
            if ( responseDecl == null )
                throw new InitializationException("X|X "+responsePointer+" ͒`ĂȂ");

            if ( log != null ) {
                if ( !log.equals(LOG_FATAL) && !log.equals(LOG_ERROR) && !log.equals(LOG_WARN) &&
                        !log.equals(LOG_INFO) && !log.equals(LOG_DEBUG) && !log.equals(LOG_TRACE) ) {
                    throw new InitializationException("sȃOx̎w \""+log+"\"");
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new InitializationException("ONX \""+type+"\" Ȃ");
        }
    }


}
