/*
 * $Revision: 1.3 $ $Date: 2005/04/11 16:33:29 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat.v1.config;

import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;

/**
 * feat-config.xmlfeaturevfB
 */
public class FeatureConfig implements ConfigElement {

    private FeatConfig featConfig;
    private FeatureDeclaration featureDecl;

    // JiBX
    private String configFile;
    private String templatePath;


    public FeatureConfig() {
        configFile = null;
        templatePath = null;
        featureDecl = null;
    }

    public FileLocator getConfigFileLocation() {
        return getFeatConfig().getConfigLocation().newLocation(configFile);
    }

    public FileLocator getTemplateLocation() {
        return getFeatConfig().getAppRoot().newLocation(templatePath);
    }

    public FeatConfig getFeatConfig() {
        return featConfig;
    }

    public FeatureDeclaration getFeatureDeclaration() {
        return featureDecl;
    }
    public void setFeatureDeclaration(FeatureDeclaration featureDec) {
        this.featureDecl = featureDec;
    }

    public void postset(IUnmarshallingContext uctx) {
        featConfig = (FeatConfig)uctx.getStackObject(1);
    }


    // ConfigElement̎

    public void init() throws InitializationException {
        if ( configFile == null )
            throw new InitializationException("Feature̐ݒt@Cw肳ĂȂ");
        if ( templatePath == null )
            throw new InitializationException("ev[g̃pXw肳ĂȂ");

        featureDecl.init();
    }

    public void validate() throws InitializationException {
        featureDecl.validate();
    }

    public String getName() {
        if ( featureDecl == null )
            return null;
        else
            return featureDecl.getName();
    }
}
