/*
 * $Revision: 1.4 $ $Date: 2005/05/04 15:59:33 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

package feat.v1.config;

import java.io.IOException;
import java.io.InputStream;

import feat.v1.FeatException;

/**
 * t@C̏ꏊ\߂̃C^tF[XB
 */
public interface FileLocator {

    /**
     * t@CJInputStreamԂB
     * @throws FeatException
     * @return InputStream
     */
    public InputStream openInputStream() throws IOException;

    /**
     * t@C̏ꏊURI𕶎ɂĕԂB
     * @return
     */
    public String getURIString();

    public boolean exists();

    /**
     * ̃IuWFNg\ꏊ̃t@CԂB
     * ̃IuWFNgfBNgwĂꍇnullԂB
     * @return
     */
    public String getFilename();

    public long getLastModified() throws IOException;

    /**
     * ݂̏ꏊVꏊwIuWFNgB
     * ݈ʒuʂ̏ꏊw肷邱Ƃ͂łȂB
     * @param relativePath Vꏊ݂̏ꏊ̑Έʒuŕ\
     * @throws FeatException
     * @return FileLocator
     */
    public FileLocator newLocation(String relativePath) throws IllegalArgumentException;

    /**
     * ̃IuWFNgnewLocationōꂽIuWFNĝƂAԌɂȂIuWFNgԂB
     * g[g̏ꍇ͎gԂB
     * @return FileLocator
     */
    public FileLocator rootLocation();

}
