/*
 * $Id: ForwardResponse.java,v 1.1 2005/04/17 16:43:03 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/18
 */
package feat.v1.config;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

import feat.v1.ContextAccessor;
import feat.v1.Response;

/**
 * @author SUGIMOTO Ken-ichi
 */
public class ForwardResponse implements Response {

    private ForwardDeclaration decl;

    public ForwardResponse(ForwardDeclaration decl) {
        this.decl = decl;
    }

    public void output(ContextAccessor acc) throws ServletException {
        RequestDispatcher rd = acc.getServletContext().getRequestDispatcher(decl.getPath());
        try {
            rd.forward(acc.getRequest(), acc.getResponse());
        }
        catch (IOException ex) {
            throw new ServletException(ex);
        }
    }

}
