/*
 * $Revision: 1.4 $ $Date: 2005/05/22 14:58:43 $
 * (C) 2004 SUGIMOTO Ken-ichi
 * 쐬F 2004/09/01
 */

package feat.v1.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;
import feat.v1.ObjectUtil;
import feat.v1.View;

public class ViewDeclaration implements ConfigElement {

    private Class viewClass;
    private View view;
    private FeatureDeclaration featureDeclaration;

    // JiBX
    private String name;
    private String className;
    private ArrayList initParams;

    public ViewDeclaration() {
        initParams = new ArrayList();
    }


    public String getName() {
        return name;
    }

    public View getView() {
        return view;
    }

    public Class getViewClass() {
        return viewClass;
    }




    public FeatureDeclaration getFeatureDeclaration() {
        return featureDeclaration;
    }
    /*public void setFeatureDeclaration(FeatureDeclaration featureDeclaration) {
        this.featureDeclaration = featureDeclaration;
    }*/

    public void postset(IUnmarshallingContext uctx) {
        featureDeclaration = (FeatureDeclaration)uctx.getStackObject(1);
    }

    public void init() throws InitializationException {
        if ( className == null )
            throw new InitializationException("r[̃NXw肳ĂȂ");
    }

    public void validate() throws InitializationException {
        // view
        try {
            viewClass = ObjectUtil.loadClass(className, getFeatureDeclaration().getPackage());
            // view̃CX^X
            view = (View) ObjectUtil.newInstance(
                    viewClass, (String[])initParams.toArray(new String[initParams.size()]));
            view.setViewDeclaration(this);
        }
        catch (InstantiationException ex) {
            throw new InitializationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new InitializationException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InitializationException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new InitializationException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InitializationException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new InitializationException(ex);
        }
    }
}
