/*
 * $Id: HTMLParser15TemplateParser.java,v 1.3 2005/11/03 13:59:00 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/23
 */
package feat.v1.impl.template;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Enumeration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

import feat.v1.StringUtil;
import feat.v1.TemplateParsingException;
import feat.v1.config.FileLocator;
import feat.v1.template.HTMLAttribute;
import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLElement;
import feat.v1.template.HTMLNode;
import feat.v1.template.HTMLTemplate;
import feat.v1.template.NodeNotFoundException;
import feat.v1.template.RemarkTextException;

/**
 * HTMLParser1.5găev[gp[XNXB
 * @author SUGIMOTO Ken-ichi
 */
public class HTMLParser15TemplateParser implements feat.v1.template.HTMLTemplateParser {

    private static Log log = LogFactory.getLog(HTMLElementImpl.class);

    public HTMLParser15TemplateParser() {
    }

    /* ( Javadoc)
     * @see feat.v1.template.HTMLTemplateParser#parseTemplate(feat.v1.config.FileLocator, java.lang.String)
     */
    public HTMLTemplate parseTemplate(FileLocator loc, String encoding)
            throws TemplateParsingException, IOException {

        return parse(loc, encoding);
    }

    /**
     * HTMLp[XB
     * @param loc
     * @param encoding HTML̃GR[fBOBnullw肷META^O画fB
     * @return
     * @throws TemplateParsingException p[XɗOX[ꂽƂ
     * @throws IOException HTMLf[^ǂݍݒIOO
     */
   private HTMLTemplateImpl parse(FileLocator loc, String encoding) throws TemplateParsingException, IOException {
       HTMLTemplateImpl template = null;
       try {
           Parser parser;
           String location = loc.getURIString();
           if ( encoding == null ) {
               parser = new Parser(location);
           }
           else {
               Page page = null;
               page = new Page(new BufferedInputStream(loc.openInputStream(), 1024), encoding);
               Lexer lexer = new Lexer(page);
               parser = new Parser(lexer);
           }

           // p[Xc[ϊ
           HTMLDocument doc = null;
           doc = new HTMLElementImpl(true);
           for(NodeIterator it = parser.elements(); it.hasMoreNodes(); ) {
               Node node = it.nextNode();
               doc.addChild(convert(node));
           }
           if ( encoding == null )
               encoding = parser.getLexer().getPage().getEncoding();
           template = new HTMLTemplateImpl(loc, encoding, doc);
       }
       catch(ParserException ex) {
           throw new TemplateParsingException("p[X̗O", ex);
       }

       return template;
   }

    private HTMLNode convert(Node node) {
        if ( node instanceof TagNode ) {
            HTMLElementImpl tag = createHTMLElement((TagNode)node);

            // qm[h̕ϊ
            NodeList children = node.getChildren();
            if ( children != null ) {
                for(int i=0; i<children.size(); i++) {
                    HTMLNode converted = convert(children.elementAt(i));
                    if ( converted != null ) {
                        // P̂ő݂I^O͒O̊Jn^OƂ
                        if ( !setEndTag(tag, converted) )
                            tag.addChild(converted);
                    }
                }
            }
            return tag;
        }
        else if ( node instanceof RemarkNode ) {
            String text = ((RemarkNode)node).getText();
            try {
                return new HTMLRemarkImpl(text);
            }
            catch (RemarkTextException ex) {
                try {
                    return new HTMLRemarkImpl(StringUtil.replace(text, "--", ""));
                }
                catch (RemarkTextException ex1) {
                    log.warn("", ex1);
                    return new HTMLTextImpl("");
                }
            }
        }
        else if ( node instanceof TextNode ) {
            return new HTMLTextImpl(((TextNode)node).getText());
        }
        else
            return null;
    }

    /**
     * nodeHTMLElementImpl̃CX^XB
     * @param node
     * @return
     */
    private HTMLElementImpl createHTMLElement(TagNode node) {
        // ̃Rs[
        Enumeration attrEnum = node.getAttributesEx().elements();
        Attribute tagNameAttr = (Attribute)attrEnum.nextElement(); // ŏ̗vf̓^O

        /*if ( node.getTagName().equalsIgnoreCase("input") || node.getTagName().equalsIgnoreCase("option") )
            System.out.println("DEBUG [HTMLTagNode#<init>] node:"+node);*/

        // vf̃Rs[
        String tagName;
        if ( tagNameAttr != null )
            tagName = StringUtil.replace(tagNameAttr.getName(), "/", "");
        else
            tagName = node.getTagName();

        // Jn^O邩ǂ
        boolean startTag = !node.isEndTag();

        // I^O̕KvtO
        boolean endTag = node instanceof CompositeTag || node.isEndTag();

        HTMLElementImpl element = new HTMLElementImpl(tagName, startTag, endTag, false);

        while( attrEnum.hasMoreElements() ) {
            Attribute a = (Attribute)attrEnum.nextElement();
            HTMLAttribute ha;

            String attrName = a.getName();
            String attrValue = a.getValue();

            /*if ( attrName != null && (attrName.equals("checked") || attrName.equals("selected")) ) {
                System.out.println("DEBUG [HTMLTagNode#<init>] attr:"+a);
            }

            if ( attrValue != null && (attrValue.equals("checked") || attrValue.equals("selected")) ) {
                System.out.println("DEBUG [HTMLTagNode#<init>] attr:"+a);
            }*/

            // 
            if ( a.isWhitespace() ) {
                ha = new HTMLWhitespaceAttribute(a.getRawValue());
            }
            // 錾 ( declare )
            else if ( a.isStandAlone() ) {
                HTMLValuedAttribute hva = new HTMLValuedAttribute(a.getName(), null);
                ha = hva;
                hva.setQuote(Character.toString(a.getQuote()));
            }
            // ` ( name="value" )
            else {
                HTMLValuedAttribute hva = new HTMLValuedAttribute(a.getName(), a.getValue());
                hva.setQuote(Character.toString(a.getQuote()));

                // ̒l
                if ( a.isEmpty() )
                    hva.setValue(null);
                ha = hva;
            }
            element.addAttribute(ha, false);
        }
        // <!DOCTYPE>
        if ( tagName.equalsIgnoreCase("!DOCTYPE") )
            element.assemble();
        return element;
    }

    /**
     * parent̍Ō̃m[htag̊Jn^OȂendTagtO𗧂ĂB
     * @param parent
     * @param tag
     * @return boolean ^ÕyAƂtrueB
     */
    private boolean setEndTag(HTMLElementImpl parent, HTMLNode tag) {
        // tagI^O
        if ( tag instanceof HTMLElement ) {
            if ( !((HTMLElementImpl)tag).hasStartTag() ) {
                HTMLElement endTag = (HTMLElement)tag;
                String tagName = endTag.getTagName();

                // Õ^OJn^OAA܂I^OȂ
                try {
                    HTMLElementImpl last = (HTMLElementImpl)parent.getLastTag(tagName);
                    if ( last.hasStartTag() && !last.hasEndTag() ) {
                        // lastȍ~Ƀm[hlast̎qm[hɈړ
                        HTMLNode next = last.next;
                        if ( next != null ) {
                            TemplateUtil.moveAll(next, last);
                        }

                        // I^ÕtO
                        last.setEndTag(true);
                        return true;
                    }
                }
                catch (NodeNotFoundException ex) {
                }
                // I^OɑΉJn^OȂ(HTML̃G[ۂ)
            }
        }
        return false;
    }
}
