/*
 * $Id: ExceptionView.java,v 1.2 2005/09/08 01:32:34 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/05/20
 */
package feat.v1.view;

import feat.v1.ContextAccessor;
import feat.v1.View;
import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLElement;
import feat.v1.template.NodeNotFoundException;

/**
 * ÕbZ[W\r[B<br>
 * Ԗڂ̃p[^:bZ[Wރ^OID
 * Ԗڂ̃p[^:bZ[W̃\[X
 * @author SUGIMOTO Ken-ichi
 */
public class ExceptionView extends View {

    /* ( Javadoc)
     * @see feat.v1.View#format(feat.v1.html.HTMLTagNode, java.lang.String[], feat.v1.ContextAccessor)
     */
    public HTMLDocument format(HTMLDocument template, String[] params,
            ContextAccessor acc) throws NodeNotFoundException {
        // bZ[Wރ^OID
        String exceptionTagId = "errorlist";
        if ( params.length >= 1 )
            exceptionTagId = params[0];

        // bZ[W̓e
        String message = null;
        if ( params.length >= 2 ) {
            message = getStringResource(params[1], acc);
        }
        else {
            message = acc.getException().toString();
        }

        HTMLElement exNode = template.findElement(exceptionTagId);
        exNode.setText(message);

        return template;
    }

}
