/*
 * $Id: ExceptionConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/21
 */
package feat2.config;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * 例外遷移の設定。
 * @author SUGIMOTO Ken-ichi
 */
public class ExceptionConfig extends Config {

    private JavaIdentifier catchType;
    private Identifier responseName;

    // validationメソッドで有効になる変数 -------------------------------------

    private ResponseConfigBase response;
    private Class catchClass;


    // プロパティ -------------------------------------------------------------

    public JavaIdentifier getCatchType() {
        return catchType;
    }
    public void setCatchType(JavaIdentifier catchType) {
        this.catchType = catchType;
    }

    public Class getCatchClass() {
        return catchClass;
    }

    public Identifier getResponseName() {
        return responseName;
    }
    public void setResponseName(Identifier responseName) {
        this.responseName = responseName;
    }

    public ResponseConfigBase getResponse() {
        return response;
    }

    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "exception";
    }

    public Identifier getName() {
        return null;
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        catchClass = ConfigUtil.validateClassLoading(catchType, "catch", this, errs);
        if ( catchClass == null )
            ret = false;

        if ( ConfigUtil.validateRequired(responseName, "response", this, errs) ) {
            response = getFeatureConfig().getResponseConfig(responseName.getValue());
            if ( response == null ) {
                ret = false;
                errs.add( new ConfigError(responseName.getValue(),
                        "error.config.exception.response.notfound",
                        FeatError.ERROR, this) );

            }
        }
        else
            ret = false;

        return ret;
    }


}
