/*
 * $Id: FeatureRootConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * フィーチャー設定ファイルのルート。
 * @author SUGIMOTO Ken-ichi
 */
public class FeatureRootConfig extends Config {

    private Identifier name;
    private Boolean createSession;
    private String encoding;
    private JavaIdentifier packageName;
    private HashMap commands;
    private HashMap responses;
    private ArrayList exceptions;
    private ArrayList intercepts;
    //private Map viewdefs;
    //private Map beandefs;
    //private Map effectdefs;
    //private Map fetchdefs;
    private Resources resources;

    public FeatureRootConfig() {
        commands = new HashMap();
        responses = new HashMap();
        exceptions = new ArrayList();
        intercepts = new ArrayList();
        /*viewdefs = new HashMap();
        beandefs = new HashMap();
        effectdefs = new HashMap();
        fetchdefs = new HashMap();*/
        resources = new Resources();
    }

    public Boolean getCreateSession() {
        return createSession;
    }
    public void setCreateSession(Boolean createSesssion) {
        this.createSession = createSesssion;
    }

    public String getEncoding() {
        return encoding;
    }
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier getPackageName() {
        return packageName;
    }
    public void setPackageName(JavaIdentifier packageName) {
        this.packageName = packageName;
    }

    public void addCommand(CommandConfig command) {
        commands.put(command.getName().getValue(), command);
        command.setParent(this);
    }

    public CommandConfig getCommandConfig(String commandName) {
        CommandConfig conf = (CommandConfig)commands.get(commandName);
        return conf;
    }

    /** forward, redirect, page, data, beanxmlはここに追加。 */
    public void addResponse(ResponseConfigBase response) {
        responses.put(response.getName().getValue(), response);
        response.setParent(this);
    }
    public ResponseConfigBase getResponseConfig(String name) {
        return (ResponseConfigBase)responses.get(name);
    }


    public void addException(ExceptionConfig exception) {
        exceptions.add(exception);
        exception.setParent(this);
    }

    /**
     * 指定の例外クラスをキャッチできる例外処理の設定オブジェクトを返す。
     * @param exclass
     * @return 見つからなければnullを返す
     */
    public ExceptionConfig getException(Class exclass) {

        for (Iterator it = exceptions.iterator(); it.hasNext();) {
            ExceptionConfig exc = (ExceptionConfig) it.next();
            if ( exc.getCatchClass().isAssignableFrom(exclass) )
                return exc;
        }

        return null;

    }


    public void addIntercept(InterceptConfig intercept) {
        intercepts.add(intercept);
        intercept.setParent(this);
    }
    public InterceptConfig[] getInterceptConfigs() {
        return (InterceptConfig[])intercepts.toArray(new InterceptConfig[0]);
    }

    /*public void addViewDef(ViewConfig view, String name) {
        viewdefs.put(name, view);
        view.setParent(this);
    }

    public void addBeanDef(BeanConfig bean, String name) {
        beandefs.put(name, bean);
        bean.setParent(this);
    }

    public void addEffectDef(EffectConfig effect, String name) {
        effectdefs.put(name, effect);
        effect.setParent(this);
    }

    public void addFetchDef(FetchConfig fetch, String name) {
        fetchdefs.put(name, fetch);
        fetch.setParent(this);
    }*/

    public void addResources(Resources resources) {
        this.resources.addResources(resources);
    }

    public String getStringResource(String resourceName, Locale locale) {
        return resources.getString(resourceName, locale);
    }

    public Resources getResources() {
        return resources;
    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "feature";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        ret = ret && ConfigUtil.validateRequired(name, "name", this, errs);

        // 子要素の検証

        ret = ret && ConfigUtil.validate(commands.values().iterator(), errs);
        ret = ret && ConfigUtil.validate(responses.values().iterator(), errs);
        ret = ret && ConfigUtil.validate(exceptions.iterator(), errs);
        ret = ret && ConfigUtil.validate(intercepts.iterator(), errs);

        return ret;

    }

}
