/*
 * $Id: InterceptConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.Interceptor;
import feat2.StringUtil;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * インターセプトの設定。
 * @author SUGIMOTO Ken-ichi
 */
public class InterceptConfig extends Config {

    private JavaIdentifier className;
    private String pattern;


    // validationメソッドのあとで有効になる変数 -------------------------------

    private Class interceptorClass;
    private String[] patterns;


    // プロパティ -------------------------------------------------------------

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public String getPattern() {
        return pattern;
    }
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getPatterns() {
        return patterns;
    }

    public Identifier getName() {
        return null;
    }


    // インスタンスメソッド ---------------------------------------------------

    public Interceptor getInterceptorInstance() {

        try {

            return (Interceptor)interceptorClass.newInstance();

        }
        catch (InstantiationException ex) {
            throw new ConfigurationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException(ex);
        }

    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "intercept";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        interceptorClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( interceptorClass == null )
            ret = false;

        if ( ConfigUtil.validateRequired(pattern, "pattern", this, errs) ) {
            patterns = StringUtil.split(pattern);
        }
        else {
            ret = false;
        }

        return ret;

    }


}
