/*
 * $Id: FormControl.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/12/17
 */
package feat2.template.form;

import feat2.template.HTMLElement;

/**
 * フォームコントールのインターフェイス。
 * @author SUGIMOTO Ken-ichi
 */
public interface FormControl {

    public static final int
        TYPE_TEXT = 0x0001,
        TYPE_PASSWORD = 0x0002,
        TYPE_SUBMIT = 0x0004,
        TYPE_RESET = 0x0008,
        TYPE_FILE = 0x0010,
        TYPE_HIDDEN = 0x0020,
        TYPE_IMAGE = 0x0040,
        TYPE_BUTTON = 0x0080,
        TYPE_RADIO = 0x0100,
        TYPE_CHECKBOX = 0x0200,
        TYPE_SELECT = 0x0400,
        TYPE_TEXTAREA = 0x0800,
        TYPE_BUTTON_ELEMENT = 0x1000;


    /**
     * コントロールに値を設定する。
     * @param value
     */
    public void setValue(String value);

    /**
     * コントロールに複数の値を設定する。
     * 単一の値しか持たないコントロールには配列の最初の値が設定される。
     * @param values
     */
    public void setValues(String[] values);

    /**
     * コントロールの値を返す。
     * 複数の値を持つコントロールの場合は最初の値を返す。
     * @return value属性に値が設定されていないときはnull
     */
    public String getValue();

    /**
     * コントロールの値を返す。
     * 単一の値しか持たないコントロールの場合は要素数が1つの配列を返す。
     * @return フォームの値。値がない場合は大きさが0の配列を返す
     */
    public String[] getValues();

    /**
     * このコントールのHTML要素オブジェクトを返す。
     * @return
     */
    public HTMLElement getElement();

    /**
     * このコントロールのタイプを返す。
     * @return
     */
    public int getType();
}
