/*
 * $Revesion$ $Date: 2008-05-13 12:56:59 +0900 $
 * Copyright (C) 2004-2007 SUGIMOTO Ken-ichi
 * 作成日: 2008/04/17
 */
package feat2.test;

import java.util.Random;

import feat2.impl.Cache;
import junit.framework.TestCase;

public class CacheTest extends TestCase {

    private boolean endFlag;

    public void testPutGet() {

        Cache cache = new Cache();

        cache.put("a", "A", 1000);
        assertEquals(cache.get("a"), "A");

        System.out.println(cache.getCacheStatus());

        try {
            Thread.sleep(1100);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }

        assertNull(cache.get("a"));

        System.out.println(cache.getCacheStatus());

    }

    public void testMemoryLeak() {

        final Cache cache = new Cache();
        Random rnd = new Random();

        long startTime = System.currentTimeMillis();

        endFlag = false;

        new Thread() {
            public void run() {
                int cleanCount = 0;
                while(!endFlag) {
                    try {
                        //cache.clean(60000, 1000);
                        System.out.println("Cache Status - "+cache.getCacheStatus());
                        printMemory();

                        Thread.sleep(10000L);

                    }
                    catch(InterruptedException ex) {
                    }
                }
            }
        }.start();

        int i=0;
        while(System.currentTimeMillis() - startTime < 3600000L) {

            cache.put(Integer.toString(i), makeString(1000), 1000+rnd.nextInt(30000));
            i++;
            Thread.yield();

        }

        System.out.println("end");
        printMemory();

        endFlag = true;

    }

    private String makeString(int len) {

        char[] c = new char[len];

        Random r = new Random();

        for(int i=0; i<len; i++) {
            c[i] = (char)('a' + r.nextInt(26));
        }

        return new String(c);
    }

    private void printMemory() {
        Runtime r = Runtime.getRuntime();
        long free = r.freeMemory();
        long total = r.totalMemory();
        long max = r.maxMemory();
        System.out.println("free:"+getMemoryString(free)+" total:"+getMemoryString(total)+" max:"+getMemoryString(max));
    }

    private String getMemoryString(long memoryAmount) {

        String[] unit = {"B", "KB", "MB", "GB", "TB"};
        int unitIndex = 0;

        while(memoryAmount >= 10240) {
            unitIndex++;
            memoryAmount = memoryAmount / 1024;
        }

        return memoryAmount + unit[unitIndex];

    }

}
