/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.solr.analysis.CapitalizationFilterFactory;

class CapitalizationFilter
extends TokenFilter {
    private final CapitalizationFilterFactory factory;
    private final TermAttribute termAtt;

    public CapitalizationFilter(TokenStream in, CapitalizationFilterFactory factory) {
        super(in);
        this.factory = factory;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.termBuffer();
        int termBufferLength = this.termAtt.termLength();
        char[] backup = null;
        if (this.factory.maxWordCount < Integer.MAX_VALUE) {
            System.arraycopy(termBuffer, 0, backup, 0, termBufferLength);
        }
        if (termBufferLength < this.factory.maxTokenLength) {
            int wordCount = 0;
            int lastWordStart = 0;
            for (int i = 0; i < termBufferLength; ++i) {
                int len;
                char c = termBuffer[i];
                if (c > ' ' && c != '.' || (len = i - lastWordStart) <= 0) continue;
                this.factory.processWord(termBuffer, lastWordStart, len, wordCount++);
                lastWordStart = i + 1;
                ++i;
            }
            if (lastWordStart < termBufferLength) {
                this.factory.processWord(termBuffer, lastWordStart, termBufferLength - lastWordStart, wordCount++);
            }
            if (wordCount > this.factory.maxWordCount) {
                this.termAtt.setTermBuffer(backup, 0, termBufferLength);
            }
        }
        return true;
    }
}

