/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics.impl;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.analytics.AnalyticsHelper;
import org.mobylet.core.analytics.AnalyticsParameters;
import org.mobylet.core.analytics.AnalyticsSearchEngine;
import org.mobylet.core.analytics.AnalyticsSession;
import org.mobylet.core.analytics.AnalyticsSessionManager;
import org.mobylet.core.analytics.UniqueUserKey;
import org.mobylet.core.analytics.impl.GoogleAnalyticsConfig;
import org.mobylet.core.http.MobyletFilter;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlDecoder;
import org.mobylet.core.util.UrlEncoder;

public class GoogleAnalyticsHelper
implements AnalyticsHelper {
    public static final String HTTP_URL = "http://www.google-analytics.com/__utm.gif";
    public static final Pattern RGX_URL = Pattern.compile(".+//([^/]+)(/.*)");
    public static final Charset UTF8 = Charset.forName("utf-8");
    public static final Charset WIN31J = Charset.forName("windows-31j");
    public static final Pattern RGX_SEARCH_EZWEB = Pattern.compile("query=[^&]+");
    public static final Pattern RGX_SEARCH_YAHOO = Pattern.compile("p=[^&]+");
    public static final Pattern RGX_SEARCH_GOOGLE = Pattern.compile("q=[^&]+");
    public static final Pattern RGX_SEARCH_CHARSET_GOOGLE = Pattern.compile("ie=[^&]+");

    @Override
    public String getURL(AnalyticsParameters p) {
        if (p.getCarrier() == Carrier.OTHER) {
            return null;
        }
        AnalyticsSessionManager manager = SingletonUtils.get(AnalyticsSessionManager.class);
        AnalyticsSession session = manager.get(p.getVisitorNo());
        AnalyticsSearchEngine ase = this.getAnalyticsSearchEngine(p.getReferer());
        StringBuilder buf = new StringBuilder();
        buf.append(HTTP_URL).append("?utmwv=1").append("&utmn=" + p.getUtmn()).append("&utmsr=" + p.getDisplaySize()).append("&utmsc=" + p.getProcessor()).append("&utmcs=utf-8").append("&utmul=" + p.getUseLanguage()).append("&utmje=0").append("&utmfl=-").append("&utmdt=-").append("&utmhn=" + p.getDomain()).append("&utmr=" + UrlEncoder.encode(p.getReferer(), UTF8)).append("&utmp=" + UrlEncoder.encode(p.getUri(), UTF8)).append("&utmac=" + p.getUrchinId()).append("&utmcc=" + UrlEncoder.encode("__utma=" + p.getDomainHash() + "." + p.getVisitorNo() + "." + session.getFirstTmString() + "." + session.getPreviousTmString() + "." + session.getCurrentTmString() + "." + session.getVisitCount() + ";+" + "__utmb=" + p.getDomainHash() + ";+" + "__utmc=" + p.getDomainHash() + ";+" + "__utmz=" + p.getDomainHash() + "." + session.getFirstTmString() + "." + session.getVisitCount() + "." + "1" + "." + "utmcsr=" + ase.getUTMCSR() + "|" + "utmccn=" + "(" + ase.getUTMCMD() + ")" + "|" + "utmcmd=" + ase.getUTMCMD() + "|" + "utmctr=" + UrlEncoder.encode(ase.getEncodedSearchWords(), UTF8) + ";" + "__utmv=" + p.getDomainHash() + "." + p.getVisitorNo() + ";", UTF8));
        return buf.toString();
    }

    @Override
    public AnalyticsParameters getParameters(String id) {
        String referer;
        Matcher urlMatcher;
        AnalyticsParameters parameters = new AnalyticsParameters(id);
        GoogleAnalyticsConfig config = SingletonUtils.get(GoogleAnalyticsConfig.class);
        String visitorId = null;
        UniqueUserKey key = config.getUniqueUserKey();
        switch (key) {
            case UID: {
                visitorId = MobyletFactory.getInstance().getUid();
                break;
            }
            case GUID: {
                visitorId = MobyletFactory.getInstance().getGuid();
                break;
            }
            case JSESSIONID: {
                visitorId = RequestUtils.get().getSession(true).getId();
            }
        }
        if (visitorId == null) {
            visitorId = "" + System.currentTimeMillis() + System.nanoTime();
        }
        parameters.setVisitorId(visitorId);
        parameters.setUserAgent(RequestUtils.getUserAgent());
        String url = null;
        if (StringUtils.isNotEmpty(config.getRequestUrlHeader())) {
            url = RequestUtils.get().getHeader(config.getRequestUrlHeader());
        }
        if (url == null) {
            url = RequestUtils.getMobyletContext().get(MobyletFilter.NativeUrl.class).toString();
        }
        if ((urlMatcher = RGX_URL.matcher(url)).find()) {
            parameters.setDomain(urlMatcher.group(1));
            parameters.setUri(this.getCleanUrl(urlMatcher.group(2)));
        }
        if ((referer = RequestUtils.get().getHeader("Referer")) == null) {
            referer = "-";
        }
        parameters.setReferer(this.getCleanUrl(referer));
        return parameters;
    }

    protected AnalyticsSearchEngine getAnalyticsSearchEngine(String referer) {
        Matcher matcher;
        AnalyticsSearchEngine ase = new AnalyticsSearchEngine();
        if (StringUtils.isEmpty(referer)) {
            return ase;
        }
        if (referer.contains("ezsch.ezweb.ne.jp")) {
            Matcher matcher2 = RGX_SEARCH_EZWEB.matcher(referer);
            if (matcher2.find()) {
                String words = matcher2.group();
                ase.setType(AnalyticsSearchEngine.SearchEngineType.EZWEB);
                ase.setEncodedSearchWords(UrlDecoder.decode(words.substring(6), WIN31J));
            }
        } else if (referer.contains("search.mobile.yahoo.co.jp")) {
            Matcher matcher3 = RGX_SEARCH_YAHOO.matcher(referer);
            if (matcher3.find()) {
                String words = matcher3.group();
                ase.setType(AnalyticsSearchEngine.SearchEngineType.YAHOO_MOBILE);
                ase.setEncodedSearchWords(UrlDecoder.decode(words.substring(2), WIN31J));
            }
        } else if (referer.contains("www.google.co.jp/m") && (matcher = RGX_SEARCH_GOOGLE.matcher(referer)).find()) {
            String enc;
            Matcher charsetMatcher = RGX_SEARCH_CHARSET_GOOGLE.matcher(referer);
            Charset charset = null;
            if (charsetMatcher.find() && "shift_jis".equals((enc = charsetMatcher.group()).substring(3).toLowerCase())) {
                charset = WIN31J;
            }
            if (charset == null) {
                charset = UTF8;
            }
            String words = matcher.group();
            ase.setType(AnalyticsSearchEngine.SearchEngineType.GOOGLE_MOBILE);
            ase.setEncodedSearchWords(UrlDecoder.decode(words.substring(2), charset));
        }
        return ase;
    }

    protected String getCleanUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        return url.replaceAll(";jsessionid=[a-zA-Z0-9.]+", "").replaceAll("(guid|GUID)=(on|ON)", "").replaceAll("(uid|UID)=[a-zA-Z0-9]{12}", "");
    }
}

