/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.config.xml;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Stack;
import org.mobylet.core.Carrier;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.config.enums.JSession;
import org.mobylet.core.config.xml.MobyletConfigXml;
import org.mobylet.core.initializer.MobyletInitializer;
import org.mobylet.core.initializer.impl.MobyletInitializerImpl;
import org.mobylet.core.type.ContentType;
import org.mobylet.core.util.ConfigUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MobyletConfigXmlReader
extends DefaultHandler
implements MobyletConfigXml {
    public static final String CONFIG_PATH = "mobylet.xml";
    protected Stack<String> tagStack;
    protected MobyletConfig config;
    protected String value;
    protected String tmpProxyHost;
    protected String tmpProxyPort;

    public MobyletConfigXmlReader(String configDir) {
        this.config = new MobyletConfig(configDir);
        if (!XmlUtils.parseSax(configDir + CONFIG_PATH, (DefaultHandler)this)) {
            this.config.addInitializer(new MobyletInitializerImpl());
            SingletonUtils.put(this.config);
        }
    }

    public MobyletConfig getConfig() {
        return this.config;
    }

    @Override
    public void startDocument() throws SAXException {
        this.tagStack = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
        SingletonUtils.put(this.config);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.tagStack.push(name);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.tagStack.pop();
        if (StringUtils.isNotEmpty(this.value)) {
            this.value = ConfigUtils.parseValue(this.value);
        }
        if (name.equals("basedir")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("device") && StringUtils.isNotEmpty(this.value)) {
                this.config.setDeviceDir(this.value);
            } else if (parent.equals("emoji") && StringUtils.isNotEmpty(this.value)) {
                this.config.setEmojiDir(this.value);
            }
        } else if (name.equals("imagePath")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("emoji") && StringUtils.isNotEmpty(this.value)) {
                this.config.setEmojiImagePath(this.value);
            }
        } else if (name.equals("chain")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("initializers") && StringUtils.isNotEmpty(this.value)) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(this.value);
                }
                catch (ClassNotFoundException e) {
                    throw new MobyletRuntimeException("INITIALIZER\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 = " + this.value, e);
                }
                if (MobyletInitializer.class.isAssignableFrom(clazz)) {
                    MobyletInitializer initializer = null;
                    try {
                        initializer = (MobyletInitializer)MobyletInitializer.class.cast(clazz.newInstance());
                    }
                    catch (InstantiationException e) {
                        throw new MobyletRuntimeException("INITIALIZER\u30af\u30e9\u30b9\u3092\u751f\u6210\u51fa\u6765\u307e\u305b\u3093 = " + this.value, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new MobyletRuntimeException("INITIALIZER\u30af\u30e9\u30b9\u306b\u30a2\u30af\u30bb\u30b9\u51fa\u6765\u307e\u305b\u3093 = " + this.value, e);
                    }
                    this.config.addInitializer(initializer);
                }
            }
        } else if (name.equals("carrier")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("through") && StringUtils.isNotEmpty(this.value)) {
                Carrier carrier = null;
                if (StringUtils.isEmpty(this.value) || (carrier = Carrier.valueOf(this.value)) == null) {
                    throw new MobyletRuntimeException("\u6307\u5b9a\u3057\u305fCarrier\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 = " + this.value, null);
                }
                this.config.addThroughCarrier(carrier);
            }
        } else if (name.equals("host") || name.equals("port")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("proxy") && StringUtils.isNotEmpty(this.value)) {
                if (name.equals("host")) {
                    this.tmpProxyHost = this.value;
                } else if (name.equals("port")) {
                    this.tmpProxyPort = this.value;
                }
            }
        } else if (name.equals("proxy")) {
            int proxyPort = 80;
            try {
                proxyPort = Integer.parseInt(this.tmpProxyPort);
            }
            catch (Exception e) {
                // empty catch block
            }
            InetSocketAddress proxyAddress = new InetSocketAddress(this.tmpProxyHost, proxyPort);
            this.config.setHttpProxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
            this.tmpProxyHost = null;
            this.tmpProxyPort = null;
        } else if (name.equals("contentType")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("default") && StringUtils.isNotEmpty(this.value)) {
                ContentType contentType = ContentType.valueOf(this.value);
                this.config.setContentType(contentType);
            }
        } else if (name.equals("jsession")) {
            JSession jSession = JSession.valueOf(this.value);
            if (jSession != null) {
                this.config.setJSession(jSession);
            }
        } else if (name.equals("mobylet-class")) {
            String parent;
            String string = parent = this.tagStack.size() > 0 ? this.tagStack.peek() : null;
            if (parent == null) {
                this.value = null;
                return;
            }
            if (parent.equals("implements") && StringUtils.isNotEmpty(this.value)) {
                this.config.setMobyletClass(this.value);
            }
        } else if (name.equals("cssExpand")) {
            boolean useCSSExpand = new Boolean(this.value);
            this.config.setUseCSSExpand(useCSSExpand);
        }
        this.value = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String tag = this.tagStack.peek();
        if (tag.equals("chain") || tag.equals("basedir") || tag.equals("imagePath") || tag.equals("carrier") || tag.equals("contentType") || tag.equals("jsession") || tag.equals("mobylet-class") || tag.equals("cssExpand") || tag.equals("host") || tag.equals("port")) {
            this.value = StringUtils.isEmpty(this.value) ? new String(ch, start, length) : this.value + new String(ch, start, length);
        }
    }
}

