/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.http;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.mobylet.core.MobyletFactory;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.RequestUtils;
import org.mobylet.core.util.StringUtils;
import org.mobylet.core.util.UrlDecoder;

public class MobyletRequest
extends HttpServletRequestWrapper {
    public static final String POST = "POST";
    public static final String KEY = MobyletRequest.class.getName();
    public static final String CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded";
    protected HttpServletRequest request;
    protected Map<String, Object> parametersMap = Collections.synchronizedMap(new HashMap());
    protected boolean isParsedParameters = false;
    protected boolean isRequestBodyOpened = false;
    protected String queryString;

    public MobyletRequest(HttpServletRequest request) {
        super(request);
        this.request = request;
        if (request != null && request.getAttribute(KEY) != null) {
            this.parametersMap.putAll(request.getParameterMap());
        } else {
            this.setAttribute(KEY, new Object().hashCode());
        }
    }

    public String getParameter(String name) {
        Object value;
        if (this.isParsable()) {
            this.parseParameters();
        }
        if ((value = this.getParameterMap().get(name)) == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public Map getParameterMap() {
        if (this.isParsable()) {
            this.parseParameters();
        }
        if (RequestUtils.isIncludeScope()) {
            HashMap<String, Object> includeParametersMap = new HashMap<String, Object>();
            includeParametersMap.putAll(super.getParameterMap());
            includeParametersMap.putAll(this.parametersMap);
            return includeParametersMap;
        }
        return this.parametersMap;
    }

    public Enumeration getParameterNames() {
        if (this.isParsable()) {
            this.parseParameters();
        }
        return new Enumerator(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        Object value;
        if (this.isParsable()) {
            this.parseParameters();
        }
        if ((value = this.getParameterMap().get(name)) == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            String[] values = new String[]{(String)value};
            return values;
        }
        String[] values = new String[]{value.toString()};
        return values;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.isRequestBodyOpened) {
            this.isRequestBodyOpened = true;
            return super.getInputStream();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseParameters() {
        Map<String, Object> map = this.parametersMap;
        synchronized (map) {
            String queryString = this.getQueryString();
            if (StringUtils.isNotEmpty(queryString)) {
                this.mergeParametersString(queryString);
            }
            int contentLength = this.getContentLength();
            if (POST.equalsIgnoreCase(this.getMethod()) && contentLength > 0) {
                String contentType = this.getContentType();
                if (StringUtils.isEmpty(contentType)) {
                    return;
                }
                int index = 0;
                index = contentType.indexOf(59);
                if ((contentType = index > 0 ? contentType.substring(0, index).trim() : contentType.trim()).equals(CONTENT_TYPE_URLENCODED)) {
                    try {
                        ServletInputStream inputStream = this.getInputStream();
                        if (inputStream != null) {
                            this.mergeParametersString(new String(InputStreamUtils.getBytesToNull((InputStream)inputStream, contentLength)));
                        }
                    }
                    catch (Exception e) {
                        throw new MobyletRuntimeException("\u30d1\u30e9\u30e1\u30fc\u30bf\u30de\u30fc\u30b8\u51e6\u7406\u6642\u306b\u4f8b\u5916\u767a\u751f", e);
                    }
                }
            }
            Set<Map.Entry<String, Object>> entrySet = this.parametersMap.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                Object value = entry.getValue();
                if (!(value instanceof Set)) continue;
                Set set = (Set)Set.class.cast(value);
                String[] array = set.toArray(new String[set.size()]);
                this.parametersMap.put(entry.getKey(), array);
            }
            this.isParsedParameters = true;
        }
    }

    protected void mergeParametersString(String q) {
        String[] keyValues;
        HashMap mergeMap = new HashMap();
        if (StringUtils.isEmpty(q)) {
            return;
        }
        Charset orgCharset = MobyletFactory.getInstance().getDialect().getCharset();
        for (String keyValue : keyValues = q.split("[&]")) {
            int index = 0;
            index = keyValue.indexOf(61);
            if (index <= 0) continue;
            String key = UrlDecoder.decode(keyValue.substring(0, index), orgCharset);
            String val = UrlDecoder.decode(keyValue.substring(index + 1), orgCharset);
            if (mergeMap.containsKey(key)) {
                Object valueSet = mergeMap.get(key);
                if (valueSet instanceof Set) {
                    ((Set)valueSet).add(val);
                } else if (valueSet instanceof String[]) {
                    String[] varList = (String[])valueSet;
                    LinkedHashSet<String> tmpSet = new LinkedHashSet<String>();
                    for (String var : varList) {
                        tmpSet.add(var);
                    }
                    tmpSet.add(val);
                    valueSet = tmpSet;
                }
                mergeMap.put(key, valueSet);
                continue;
            }
            LinkedHashSet<String> valSet = new LinkedHashSet<String>();
            valSet.add(val);
            mergeMap.put(key, valSet);
        }
        this.parametersMap.putAll(mergeMap);
    }

    protected boolean isParsable() {
        return !this.isParsedParameters;
    }

    public static class Enumerator<E>
    implements Enumeration<E> {
        protected Iterator<E> iterator;

        public Enumerator(Set<E> set) {
            this.iterator = set.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

