/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.core.image.ImageClipRectangle;
import org.mobylet.core.image.ImageCodec;
import org.mobylet.core.image.ImageConfig;
import org.mobylet.core.image.ImageScaler;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.InputStreamUtils;
import org.mobylet.core.util.InputToOutputStreamUtils;
import org.mobylet.core.util.OutputStreamUtils;
import org.mobylet.core.util.SingletonUtils;

public class MobyletImageMagickScaler
implements ImageScaler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void scale(InputStream imgStream, OutputStream outImage, ImageCodec imageCodec, Integer newWidth, ScaleType scaleType) {
        if (newWidth == null) {
            try {
                InputToOutputStreamUtils.writeAll(imgStream, outImage);
                return;
            }
            finally {
                InputStreamUtils.closeQuietly(imgStream);
            }
        }
        ImageConfig config = SingletonUtils.get(ImageConfig.class);
        String workDir = config.getImageMagickWorkDir();
        String convertPath = config.getImageMagickPath();
        String command = null;
        FileOutputStream workFOS = null;
        FileInputStream workFIS = null;
        String workSrcFilePath = workDir + UUID.randomUUID().toString();
        String workDstFilePath = workDir + UUID.randomUUID().toString();
        File workSrcFile = new File(workSrcFilePath);
        File workDstFile = new File(workDstFilePath);
        try {
            workFOS = new FileOutputStream(workSrcFile);
            InputToOutputStreamUtils.writeAll(imgStream, workFOS);
            switch (scaleType) {
                case FITWIDTH: {
                    command = convertPath + "convert -geometry " + newWidth + " " + workSrcFilePath + " " + workDstFilePath;
                    break;
                }
                case INSQUARE: {
                    command = convertPath + "convert -geometry " + newWidth + "x" + newWidth + " " + workSrcFilePath + " " + workDstFilePath;
                    break;
                }
                case CLIPSQUARE: {
                    command = convertPath + "convert -gravity center -crop " + newWidth + "x" + newWidth + "+0+0 " + workSrcFilePath + " " + workDstFilePath;
                    break;
                }
            }
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(command);
            process.waitFor();
            if (process.exitValue() != 0) {
                InputStream errorStream = process.getErrorStream();
                String errorInfo = new String(InputStreamUtils.getAllBytes(errorStream));
                throw new MobyletRuntimeException("\u753b\u50cf\u5909\u63db\u4e2d\u306b\u4f8b\u5916\u767a\u751f [" + errorInfo + "]", null);
            }
            workFIS = new FileInputStream(workDstFile);
            InputToOutputStreamUtils.writeAll(workFIS, outImage);
        }
        catch (IOException e) {
            try {
                throw new MobyletRuntimeException("\u753b\u50cf\u5909\u63db\u4e2d\u306bI/O\u4f8b\u5916\u767a\u751f", e);
                catch (InterruptedException e2) {
                    throw new MobyletRuntimeException("\u753b\u50cf\u5909\u63db\u4e2d\u306b\u5272\u308a\u8fbc\u307f\u4f8b\u5916\u767a\u751f", e2);
                }
            }
            catch (Throwable throwable) {
                OutputStreamUtils.closeQuietly(workFOS);
                InputStreamUtils.closeQuietly(workFIS);
                workSrcFile.delete();
                workDstFile.delete();
                throw throwable;
            }
        }
        OutputStreamUtils.closeQuietly(workFOS);
        InputStreamUtils.closeQuietly(workFIS);
        workSrcFile.delete();
        workDstFile.delete();
    }

    @Override
    public ImageClipRectangle getClipRectangle(Integer width, Integer height, Integer newWidth, ScaleType scaleType) {
        return null;
    }
}

