/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.css;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.mobylet.core.util.StringUtils;
import org.mobylet.view.css.CSSCond;
import org.mobylet.view.css.XhtmlNode;

public class CSSCondContainer {
    protected Set<CSSCond> allCond;
    protected LinkedHashMap<String, Set<CSSCond>> tagMap;
    protected LinkedHashMap<String, Set<CSSCond>> styleIdMap;
    protected LinkedHashMap<String, Set<CSSCond>> styleClassMap;

    public CSSCondContainer() {
        this.init();
    }

    public String getStyle(XhtmlNode node) {
        LinkedHashSet<CSSCond> condSet = new LinkedHashSet<CSSCond>();
        this.addCondSet(condSet, node);
        if (condSet.size() == 0) {
            return null;
        }
        HashMap<String, String> styleMap = new HashMap<String, String>();
        for (CSSCond cond : condSet) {
            if (!cond.match(node)) continue;
            styleMap.putAll(cond.getValueMap());
        }
        if (styleMap.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : styleMap.entrySet()) {
                sb.append((String)entry.getKey() + ":");
                sb.append((String)entry.getValue() + ";");
            }
            return sb.toString();
        }
        return null;
    }

    public void putAll(CSSCondContainer container) {
        if (container == null || container.allCond.size() == 0) {
            return;
        }
        for (CSSCond cond : container.allCond) {
            this.put(cond);
        }
    }

    public void put(CSSCond cond) {
        Set<CSSCond> set;
        if (cond == null) {
            return;
        }
        if (StringUtils.isNotEmpty(cond.getTag())) {
            set = this.tagMap.get(cond.getTag());
            if (set == null) {
                set = new LinkedHashSet<CSSCond>();
                this.tagMap.put(cond.getTag(), set);
            }
            set.add(cond);
        }
        if (StringUtils.isNotEmpty(cond.getStyleId())) {
            set = this.styleIdMap.get(cond.getStyleId());
            if (set == null) {
                set = new LinkedHashSet<CSSCond>();
                this.styleIdMap.put(cond.getStyleId(), set);
            }
            set.add(cond);
        }
        if (StringUtils.isNotEmpty(cond.getStyleClass())) {
            set = this.styleClassMap.get(cond.getStyleClass());
            if (set == null) {
                set = new LinkedHashSet<CSSCond>();
                this.styleClassMap.put(cond.getStyleClass(), set);
            }
            set.add(cond);
        }
        this.allCond.add(cond);
    }

    protected void init() {
        this.allCond = new LinkedHashSet<CSSCond>();
        this.tagMap = new LinkedHashMap();
        this.styleIdMap = new LinkedHashMap();
        this.styleClassMap = new LinkedHashMap();
    }

    protected void addCondSet(Set<CSSCond> condSet, XhtmlNode node) {
        Set<CSSCond> set = this.tagMap.get(node.getTag());
        if (set != null) {
            condSet.addAll(set);
        }
        if ((set = this.styleIdMap.get(node.getStyleId())) != null) {
            condSet.addAll(set);
        }
        if (node.getStyleClasses() != null) {
            for (String styleClass : node.getStyleClasses()) {
                set = this.styleClassMap.get(styleClass);
                if (set == null) continue;
                condSet.addAll(set);
            }
        }
    }
}

