/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.css;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.mobylet.core.util.StringUtils;
import org.mobylet.view.css.CSSCondContainer;
import org.mobylet.view.css.XhtmlNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CSSExpandHandler
extends DefaultHandler {
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String SL = "/";
    protected CSSCondContainer container;
    protected XhtmlNode node;
    protected Stack<String> tagStack;
    protected Map<String, Integer> indexMap;
    protected StringBuilder buf;

    public CSSExpandHandler(CSSCondContainer container) {
        this.container = container;
    }

    @Override
    public void startDocument() throws SAXException {
        this.buf = new StringBuilder();
        this.tagStack = new Stack();
        this.indexMap = new HashMap<String, Integer>();
    }

    @Override
    public void endDocument() throws SAXException {
        this.tagStack = null;
        this.indexMap = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        Integer index = this.getIndex();
        this.tagStack.push(name);
        XhtmlNode newNode = new XhtmlNode(name, attributes.getValue("id"), attributes.getValue("class"), index);
        if (this.node != null) {
            newNode.setParent(this.node);
        }
        this.node = newNode;
        StringBuilder tagBuf = new StringBuilder();
        tagBuf.append(name);
        if (this.container != null) {
            String styleString = this.container.getStyle(this.node);
            if (attributes.getValue("style") != null) {
                styleString = attributes.getValue("style") + styleString;
            }
            boolean existsStyle = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("style".equals(attName)) {
                    tagBuf.append(" " + attName + "=\"" + styleString.replace("\"", "\\\"") + "\"");
                    existsStyle = true;
                    continue;
                }
                tagBuf.append(" " + attName + "=\"" + attributes.getValue(attName).replace("\"", "\\\"") + "\"");
            }
            if (!existsStyle && StringUtils.isNotEmpty(styleString)) {
                tagBuf.append(" style=\"" + styleString.replace("\"", "\\\"") + "\"");
            }
        } else {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                tagBuf.append(" " + attName + "=\"" + attributes.getValue(attName).replace("\"", "\\\"") + "\"");
            }
        }
        this.buf.append(LT + tagBuf.toString() + GT);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.tagStack.pop();
        if (this.node != null) {
            this.node = this.node.getParent();
        }
        this.buf.append("</" + name + GT);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }

    public String toString() {
        return this.buf.toString();
    }

    protected Integer getIndex() {
        String parentNodeKey = this.tagStack.toString();
        Integer index = this.indexMap.get(parentNodeKey);
        if (index == null) {
            this.indexMap.put(parentNodeKey, 1);
            index = 1;
        } else {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            this.indexMap.put(parentNodeKey, index);
        }
        return index;
    }
}

