/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.seasar.robot.dbflute.helper.beans.DfBeanDesc;
import org.seasar.robot.dbflute.helper.beans.DfPropertyDesc;
import org.seasar.robot.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.seasar.robot.dbflute.util.DfReflectionUtil;
import org.seasar.robot.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPropertyDescImpl
implements DfPropertyDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String propertyName;
    private Class<?> propertyType;
    private Method readMethod;
    private Method writeMethod;
    private Field field;
    private DfBeanDesc beanDesc;
    private Constructor<?> stringConstructor;
    private Method valueOfMethod;
    private boolean readable = false;
    private boolean writable = false;

    public DfPropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, DfBeanDesc beanDesc) {
        this(propertyName, propertyType, readMethod, writeMethod, null, beanDesc);
    }

    public DfPropertyDescImpl(String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field, DfBeanDesc beanDesc) {
        if (propertyName == null) {
            String msg = "The argument 'propertyName' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        if (propertyType == null) {
            String msg = "The argument 'propertyType' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
        this.setField(field);
        this.beanDesc = beanDesc;
        this.setupStringConstructor();
        this.setupValueOfMethod();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this.propertyType.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(String.class)) continue;
            this.stringConstructor = con;
            break;
        }
    }

    private void setupValueOfMethod() {
        Method[] methods = this.propertyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method) || !DfReflectionUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this.valueOfMethod = method;
            break;
        }
    }

    @Override
    public DfBeanDesc getBeanDesc() {
        return this.beanDesc;
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public final Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public final Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public final void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.readable = true;
        }
    }

    @Override
    public final boolean hasReadMethod() {
        return this.readMethod != null;
    }

    @Override
    public final Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public final void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.writable = true;
        }
    }

    @Override
    public final boolean hasWriteMethod() {
        return this.writeMethod != null;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public void setField(Field field) {
        this.field = field;
        if (field != null && DfReflectionUtil.isPublic(field.getModifiers())) {
            this.readable = true;
            this.writable = true;
        }
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public final Object getValue(Object target) {
        try {
            if (!this.readable) {
                throw new IllegalStateException(this.propertyName + " is not readable.");
            }
            if (this.hasReadMethod()) {
                return DfReflectionUtil.invoke(this.readMethod, target, EMPTY_ARGS);
            }
            return DfReflectionUtil.getValue(this.field, target);
        }
        catch (Throwable t) {
            throw new DfBeanIllegalPropertyException(this.beanDesc.getBeanClass(), this.propertyName, t);
        }
    }

    @Override
    public final void setValue(Object target, Object value) {
        try {
            value = this.convertIfNeed(value);
            if (!this.writable) {
                throw new IllegalStateException(this.propertyName + " is not writable.");
            }
            if (this.hasWriteMethod()) {
                DfReflectionUtil.invoke(this.writeMethod, target, new Object[]{value});
            } else {
                DfReflectionUtil.setValue(this.field, target, value);
            }
        }
        catch (Throwable t) {
            throw new DfBeanIllegalPropertyException(this.beanDesc.getBeanClass(), this.propertyName, t);
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this.propertyName);
        buf.append(",propertyType=");
        buf.append(this.propertyType.getName());
        buf.append(",readMethod=");
        buf.append(this.readMethod != null ? this.readMethod.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this.writeMethod != null ? this.writeMethod.getName() : "null");
        return buf.toString();
    }

    @Override
    public Object convertIfNeed(Object arg) {
        if (this.propertyType.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        if (Number.class.isAssignableFrom(this.propertyType)) {
            return this.convertNumber(arg);
        }
        if (Date.class.isAssignableFrom(this.propertyType)) {
            return this.convertDate(arg);
        }
        if (Boolean.class.isAssignableFrom(this.propertyType)) {
            return DfTypeUtil.toBoolean(arg);
        }
        if (arg != null && arg.getClass() != String.class && String.class == this.propertyType) {
            return arg.toString();
        }
        if (arg instanceof String && !String.class.equals(this.propertyType)) {
            return this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this.propertyType)) {
            return DfTypeUtil.toCalendar(arg);
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return DfTypeUtil.convertPrimitiveWrapper(this.propertyType, arg);
    }

    private Object convertNumber(Object arg) {
        return DfTypeUtil.toNumber(this.propertyType, arg);
    }

    private Object convertDate(Object arg) {
        if (this.propertyType == Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this.propertyType == Timestamp.class) {
            return DfTypeUtil.toTimestamp(arg);
        }
        if (this.propertyType == java.sql.Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this.propertyType == Time.class) {
            return DfTypeUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithString(Object arg) {
        if (this.stringConstructor != null) {
            return DfReflectionUtil.newInstance(this.stringConstructor, new Object[]{arg});
        }
        if (this.valueOfMethod != null) {
            return DfReflectionUtil.invoke(this.valueOfMethod, null, new Object[]{arg});
        }
        return arg;
    }
}

