/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.infra.dfprop;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.robot.dbflute.helper.mapstring.MapListString;
import org.seasar.robot.dbflute.helper.mapstring.impl.MapListStringImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfPropFileReader {
    private static final String UTF8_ENCODING = "UTF-8";
    public static final String FILE_ENCODING = "UTF-8";
    public static final String LINE_COMMENT_MARK = "#";

    public Map<String, Object> readMap(InputStream ins) {
        String encoding = this.getFileEncoding();
        String lineCommentMark = this.getLineCommentMark();
        StringBuilder sb = new StringBuilder();
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            ir = new InputStreamReader(ins, encoding);
            br = new BufferedReader(ir);
            int count = -1;
            while (true) {
                ++count;
                String lineString = br.readLine();
                if (lineString == null) {
                    break;
                }
                if (count == 0) {
                    lineString = this.removeInitialUnicodeBomIfNeeds(encoding, lineString);
                }
                if (lineString.trim().length() == 0 || lineCommentMark != null && lineString.trim().startsWith(lineCommentMark)) continue;
                sb.append(lineString);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        if (sb.toString().trim().length() == 0) {
            return new LinkedHashMap<String, Object>();
        }
        MapListString mapListString = this.createMapListString();
        return mapListString.generateMap(sb.toString());
    }

    public Map<String, String> readMapAsStringValue(InputStream ins) {
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (String)entry.getValue());
        }
        return resultMap;
    }

    public Map<String, List<String>> readMapAsStringListValue(InputStream ins) {
        LinkedHashMap<String, List<String>> resultMap = this.newLinkedHashMap();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (List)entry.getValue());
        }
        return resultMap;
    }

    public Map<String, Map<String, String>> readMapAsStringMapValue(InputStream ins) {
        LinkedHashMap<String, Map<String, String>> resultMap = this.newLinkedHashMap();
        Map<String, Object> map = this.readMap(ins);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            resultMap.put(entry.getKey(), (Map)entry.getValue());
        }
        return resultMap;
    }

    public List<Object> readList(InputStream ins) {
        String encoding = this.getFileEncoding();
        String lineCommentMark = this.getLineCommentMark();
        StringBuilder sb = new StringBuilder();
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            ir = new InputStreamReader(ins, encoding);
            br = new BufferedReader(ir);
            int count = -1;
            while (true) {
                ++count;
                String lineString = br.readLine();
                if (lineString == null) {
                    break;
                }
                if (count == 0) {
                    lineString = this.removeInitialUnicodeBomIfNeeds(encoding, lineString);
                }
                if (lineString.trim().length() == 0 || lineCommentMark != null && lineString.trim().startsWith(lineCommentMark)) continue;
                sb.append(lineString);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        if (sb.toString().trim().length() == 0) {
            return new ArrayList<Object>();
        }
        MapListString mapListString = this.createMapListString();
        return mapListString.generateList(sb.toString());
    }

    public String readString(InputStream ins) {
        String encoding = this.getFileEncoding();
        String lineCommentMark = this.getLineCommentMark();
        StringBuilder sb = new StringBuilder();
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            ir = new InputStreamReader(ins, encoding);
            br = new BufferedReader(ir);
            int count = -1;
            while (true) {
                ++count;
                String lineString = br.readLine();
                if (lineString == null) {
                    break;
                }
                if (lineCommentMark != null && lineString.trim().startsWith(lineCommentMark)) continue;
                sb.append(lineString + "\n");
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "The encoding is unsupported: " + encoding;
            throw new IllegalStateException(msg, e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        return this.removeInitialUnicodeBomIfNeeds(encoding, sb.toString());
    }

    protected String getFileEncoding() {
        return "UTF-8";
    }

    protected String getLineCommentMark() {
        return LINE_COMMENT_MARK;
    }

    protected MapListString createMapListString() {
        return new MapListStringImpl();
    }

    protected String removeInitialUnicodeBomIfNeeds(String encoding, String value) {
        if ("UTF-8".equalsIgnoreCase(encoding) && value.length() > 0 && value.charAt(0) == '\ufeff') {
            value = value.substring(1);
        }
        return value;
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return new LinkedHashMap();
    }
}

