/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.jdbc.StatementConfig;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.resource.SQLExceptionHandler;

public class TnStatementFactoryImpl
implements StatementFactory {
    private static final Log _log = LogFactory.getLog(TnStatementFactoryImpl.class);
    protected StatementConfig defaultStatementConfig;
    protected boolean internalDebug;

    public PreparedStatement createPreparedStatement(Connection conn, String sql) {
        try {
            StatementConfig config = this.findStatementConfigOnThread();
            int resultSetType = config != null && config.hasResultSetType() ? config.getResultSetType() : (this.defaultStatementConfig != null && this.defaultStatementConfig.hasResultSetType() ? this.defaultStatementConfig.getResultSetType() : 1003);
            int resultSetConcurrency = 1007;
            if (this.internalDebug) {
                _log.debug((Object)("...Creating prepareStatement(sql, " + resultSetType + ", " + 1007 + ")"));
            }
            PreparedStatement ps = conn.prepareStatement(sql, resultSetType, 1007);
            if (config != null && config.hasStatementOptions()) {
                if (this.internalDebug) {
                    _log.debug((Object)("...Setting statement config as request: " + config));
                }
                this.reflectStatementOptions(config, ps);
            } else {
                this.reflectDefaultOptionsToStatementIfNeeds(ps);
            }
            return ps;
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    public CallableStatement createCallableStatement(Connection conn, String sql) {
        return this.prepareCall(conn, sql);
    }

    protected StatementConfig findStatementConfigOnThread() {
        StatementConfig config;
        if (ConditionBeanContext.isExistConditionBeanOnThread()) {
            ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
            config = cb.getStatementConfig();
        } else if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
            config = context.getStatementConfig();
        } else {
            config = null;
        }
        return config;
    }

    protected void reflectDefaultOptionsToStatementIfNeeds(PreparedStatement ps) {
        if (this.defaultStatementConfig != null && this.defaultStatementConfig.hasStatementOptions()) {
            if (this.internalDebug) {
                _log.debug((Object)("...Setting statement config as default: " + this.defaultStatementConfig));
            }
            this.reflectStatementOptions(this.defaultStatementConfig, ps);
            return;
        }
    }

    protected void reflectStatementOptions(StatementConfig config, PreparedStatement ps) {
        try {
            if (config.hasQueryTimeout()) {
                ps.setQueryTimeout(config.getQueryTimeout());
            }
            if (config.hasFetchSize()) {
                ps.setFetchSize(config.getFetchSize());
            }
            if (config.hasMaxRows()) {
                ps.setMaxRows(config.getMaxRows());
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e, ps);
        }
    }

    protected CallableStatement prepareCall(Connection conn, String sql) {
        try {
            return conn.prepareCall(sql);
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new SQLExceptionHandler().handleSQLException(e, statement);
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this.defaultStatementConfig = defaultStatementConfig;
    }

    public void setInternalDebug(boolean internalDebug) {
        this.internalDebug = internalDebug;
    }
}

