/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.robot.dbflute.bhv.core.SqlExecution;
import org.seasar.robot.dbflute.jdbc.StatementFactory;
import org.seasar.robot.dbflute.outsidesql.OutsideSqlContext;
import org.seasar.robot.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.robot.dbflute.s2dao.procedure.TnProcedureMetaData;
import org.seasar.robot.dbflute.s2dao.sqlcommand.TnSqlCommand;
import org.seasar.robot.dbflute.s2dao.sqlhandler.TnProcedureHandler;

public class TnProcedureCommand
implements TnSqlCommand,
SqlExecution {
    protected DataSource dataSource;
    protected TnResultSetHandler resultSetHandler;
    protected StatementFactory statementFactory;
    protected TnProcedureMetaData procedureMetaData;

    public TnProcedureCommand(DataSource dataSource, TnResultSetHandler resultSetHandler, StatementFactory statementFactory, TnProcedureMetaData procedureMetaData) {
        this.dataSource = dataSource;
        this.resultSetHandler = resultSetHandler;
        this.statementFactory = statementFactory;
        this.procedureMetaData = procedureMetaData;
    }

    public Object execute(Object[] args) {
        TnProcedureHandler handler = this.newArgumentDtoProcedureHandler();
        OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
        Object pmb = outsideSqlContext.getParameterBean();
        return handler.execute(new Object[]{pmb});
    }

    protected TnProcedureHandler newArgumentDtoProcedureHandler() {
        return new TnProcedureHandler(this.dataSource, this.createSql(this.procedureMetaData), this.resultSetHandler, this.statementFactory, this.procedureMetaData);
    }

    protected String createSql(TnProcedureMetaData procedureMetaData) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int size = procedureMetaData.parameterTypes().size();
        if (procedureMetaData.hasReturnParameterType()) {
            sb.append("? = ");
            --size;
        }
        sb.append("call ").append(procedureMetaData.getProcedureName()).append("(");
        for (int i = 0; i < size; ++i) {
            sb.append("?, ");
        }
        if (size > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(")}");
        return sb.toString();
    }
}

