/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.impl;

import java.lang.reflect.Method;
import org.seasar.chronos.core.annotation.task.method.CloneTask;
import org.seasar.chronos.core.annotation.task.method.JoinTask;
import org.seasar.chronos.core.annotation.task.method.NextTask;
import org.seasar.chronos.core.annotation.task.method.TaskGroup;
import org.seasar.chronos.core.annotation.type.JoinType;
import org.seasar.framework.beans.BeanDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskMethodMetaData {
    private static final long serialVersionUID = -9051823745597260320L;
    private final Method method;

    public TaskMethodMetaData(BeanDesc beanDesc, String methodName) {
        this(beanDesc.getMethod(methodName));
    }

    public TaskMethodMetaData(Method method) {
        this.method = method;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public JoinType getJoinType() {
        JoinTask joinTask = this.method.getAnnotation(JoinTask.class);
        if (joinTask != null) {
            return joinTask.value();
        }
        return JoinType.Wait;
    }

    public String getNextTask() {
        NextTask nextTask = this.method.getAnnotation(NextTask.class);
        if (nextTask != null) {
            return nextTask.value();
        }
        return null;
    }

    public long getCloneSize() {
        CloneTask cloneTask = this.method.getAnnotation(CloneTask.class);
        if (cloneTask != null) {
            return cloneTask.value();
        }
        return 1L;
    }

    public String getGroupName() {
        TaskGroup taskGroup = this.method.getAnnotation(TaskGroup.class);
        if (taskGroup != null) {
            return taskGroup.value();
        }
        return null;
    }
}

