/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.config;

import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.config.S2ModuleConfig;
import org.seasar.struts.util.RoutingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;
import org.seasar.struts.util.S2ModuleConfigUtil;
import org.seasar.struts.util.ServletContextUtil;

public class S2ActionMapping
extends ActionMapping {
    private static final long serialVersionUID = 1L;
    private static final String REDIRECT = "redirect=true";
    protected ComponentDef componentDef;
    protected ComponentDef actionFormComponentDef;
    protected BeanDesc actionBeanDesc;
    protected BeanDesc actionFormBeanDesc;
    protected ArrayMap executeConfigs = new ArrayMap();
    protected Field actionFormField;

    public S2ActionMapping() {
        this.scope = "request";
        this.validate = false;
    }

    public ActionForward createForward(String path) {
        return this.createForward(path, false);
    }

    public ActionForward createForward(String path, boolean redirect) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(REDIRECT)) {
            redirect = true;
            path = path.substring(0, path.length() - REDIRECT.length() - 1);
        }
        if (path.indexOf(":") < 0) {
            if (!path.startsWith("/")) {
                path = this.getActionPath(this.componentDef.getComponentName()) + path;
            }
            if (!redirect) {
                if (path.indexOf(46) < 0) {
                    path = this.createRoutingPath(path);
                } else {
                    String viewPrefix = ServletContextUtil.getViewPrefix();
                    if (viewPrefix != null) {
                        path = viewPrefix + path;
                    }
                }
            }
        }
        return new ActionForward(path, redirect);
    }

    protected String createRoutingPath(String path) {
        String originalPath = path;
        String queryString = "";
        int index = path.indexOf(63);
        if (index >= 0) {
            queryString = path.substring(index);
            path = path.substring(0, index);
        }
        String[] names = StringUtil.split((String)path, (String)"/");
        S2Container container = SingletonS2ContainerFactory.getContainer();
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < names.length; ++i) {
            S2ExecuteConfig executeConfig;
            String paramPath;
            String actionPath;
            if (container.hasComponentDef((Object)(sb + names[i] + "Action"))) {
                actionPath = RoutingUtil.getActionPath(names, i);
                paramPath = RoutingUtil.getParamPath(names, i + 1);
                if (StringUtil.isEmpty((String)paramPath)) {
                    return actionPath + ".do" + this.getQueryString(queryString, actionPath, paramPath);
                }
                executeConfig = S2ExecuteConfigUtil.findExecuteConfig(actionPath, paramPath);
                if (executeConfig != null) {
                    return actionPath + ".do" + this.getQueryString(queryString, actionPath, paramPath);
                }
            }
            if (container.hasComponentDef((Object)(sb + "indexAction"))) {
                actionPath = RoutingUtil.getActionPath(names, i - 1) + "/index";
                paramPath = RoutingUtil.getParamPath(names, i);
                if (StringUtil.isEmpty((String)paramPath)) {
                    return actionPath + ".do" + this.getQueryString(queryString, actionPath, paramPath);
                }
                executeConfig = S2ExecuteConfigUtil.findExecuteConfig(actionPath, paramPath);
                if (executeConfig != null) {
                    return actionPath + ".do" + this.getQueryString(queryString, actionPath, paramPath);
                }
            }
            sb.append(names[i] + "_");
        }
        if (container.hasComponentDef((Object)(sb + "indexAction"))) {
            String actionPath = RoutingUtil.getActionPath(names, names.length - 1) + "/index";
            return actionPath + ".do" + this.getQueryString(queryString, actionPath, "");
        }
        return originalPath;
    }

    protected String getActionPath(String componentName) {
        if (!componentName.endsWith("Action")) {
            throw new IllegalArgumentException(componentName);
        }
        if (componentName.equals("indexAction")) {
            return "/";
        }
        componentName = componentName.endsWith("indexAction") ? componentName.substring(0, componentName.length() - 12) : componentName.substring(0, componentName.length() - 6);
        return "/" + componentName.replace('_', '/') + "/";
    }

    protected String getQueryString(String queryString, String actionPath, String paramPath) {
        String queryString2 = "";
        S2ModuleConfig moduleConfig = S2ModuleConfigUtil.getModuleConfig();
        S2ActionMapping actionMapping = (S2ActionMapping)moduleConfig.findActionConfig(actionPath);
        S2ExecuteConfig executeConfig = actionMapping.findExecuteConfig(paramPath);
        if (executeConfig != null) {
            queryString2 = executeConfig.getQueryString(paramPath);
        } else {
            executeConfig = S2ExecuteConfigUtil.getExecuteConfig();
            if (executeConfig != null) {
                queryString2 = "?" + executeConfig.method.getName() + "=";
            }
        }
        if (StringUtil.isEmpty((String)queryString)) {
            return queryString2;
        }
        if (StringUtil.isEmpty((String)queryString2)) {
            return queryString;
        }
        return queryString + "&" + queryString2.substring(1);
    }

    public ComponentDef getComponentDef() {
        return this.componentDef;
    }

    public void setComponentDef(ComponentDef componentDef) {
        this.componentDef = componentDef;
        this.actionBeanDesc = BeanDescFactory.getBeanDesc((Class)componentDef.getComponentClass());
    }

    public ComponentDef getActionFormComponentDef() {
        if (this.actionFormField == null) {
            return this.componentDef;
        }
        if (this.actionFormComponentDef == null) {
            this.actionFormComponentDef = SingletonS2ContainerFactory.getContainer().getComponentDef(this.actionFormField.getType());
        }
        return this.actionFormComponentDef;
    }

    public BeanDesc getActionBeanDesc() {
        return this.actionBeanDesc;
    }

    public BeanDesc getActionFormBeanDesc() {
        if (this.actionFormField == null) {
            return this.actionBeanDesc;
        }
        return this.actionFormBeanDesc;
    }

    public Object getAction() {
        return this.componentDef.getComponent();
    }

    public Object getActionForm() {
        return this.getActionFormComponentDef().getComponent();
    }

    public String getPropertyAsString(String name) {
        Object target = this.getActionForm();
        BeanDesc beanDesc = this.getActionFormBeanDesc();
        Object value = null;
        if (beanDesc.hasPropertyDesc(name)) {
            value = beanDesc.getPropertyDesc(name).getValue(target);
        }
        if (value != null) {
            return value.toString();
        }
        target = this.getAction();
        beanDesc = this.getActionBeanDesc();
        if (beanDesc.hasPropertyDesc(name)) {
            value = beanDesc.getPropertyDesc(name).getValue(target);
        }
        if (value != null) {
            return value.toString();
        }
        return "null";
    }

    public String getType() {
        return this.componentDef.getComponentClass().getName();
    }

    public String[] getExecuteMethodNames() {
        return this.executeConfigs.keySet().toArray(new String[this.executeConfigs.size()]);
    }

    public S2ExecuteConfig findExecuteConfig(String paramPath) {
        for (int i = 0; i < this.executeConfigs.size(); ++i) {
            S2ExecuteConfig executeConfig = (S2ExecuteConfig)this.executeConfigs.get(i);
            if (!executeConfig.isTarget(paramPath)) continue;
            return executeConfig;
        }
        return null;
    }

    public S2ExecuteConfig findExecuteConfig(HttpServletRequest request) {
        if (this.executeConfigs.size() == 1) {
            return (S2ExecuteConfig)this.executeConfigs.get(0);
        }
        for (int i = 0; i < this.executeConfigs.size(); ++i) {
            S2ExecuteConfig executeConfig = (S2ExecuteConfig)this.executeConfigs.get(i);
            if (!executeConfig.isTarget(request)) continue;
            return executeConfig;
        }
        return this.getExecuteConfig("index");
    }

    public S2ExecuteConfig getExecuteConfig(String name) {
        return (S2ExecuteConfig)this.executeConfigs.get((Object)name);
    }

    public int getExecuteConfigSize() {
        return this.executeConfigs.size();
    }

    public void addExecuteConfig(S2ExecuteConfig executeConfig) {
        this.executeConfigs.put((Object)executeConfig.method.getName(), (Object)executeConfig);
    }

    public Field getActionFormField() {
        return this.actionFormField;
    }

    public void setActionFormField(Field actionFormField) {
        this.actionFormField = actionFormField;
        this.actionFormBeanDesc = BeanDescFactory.getBeanDesc(actionFormField.getType());
    }
}

