/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetNonStrokingSeparation;
import org.apache.pdfbox.util.operator.SetStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetStrokingRGBColor;

public class SetStrokingColor
extends OperatorProcessor {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$pdfbox$util$operator$SetStrokingColor == null ? (class$org$apache$pdfbox$util$operator$SetStrokingColor = SetStrokingColor.class$("org.apache.pdfbox.util.operator.SetStrokingColor")) : class$org$apache$pdfbox$util$operator$SetStrokingColor));
    static /* synthetic */ Class class$org$apache$pdfbox$util$operator$SetStrokingColor;

    public void process(PDFOperator operator, List arguments) throws IOException {
        PDColorSpace colorSpace = this.context.getGraphicsState().getStrokingColor().getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetStrokingCalRGBColor();
            } else if (colorSpace instanceof PDSeparation) {
                newOperator = new SetNonStrokingSeparation();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator, arguments);
            } else {
                log.info((Object)("Not supported colorspace " + colorSpace.getName() + " within operator " + operator.getOperation()));
            }
        } else {
            log.warn((Object)("Colorspace not found in " + this.getClass().getName() + ".process!!"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

