/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.exception.NonArrayInConditionRuntimeException;
import org.seasar.extension.jdbc.exception.NonBooleanIsNullConditionRuntimeException;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConditionType {
    EQ{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, "=");
        }
    }
    ,
    NE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, "<>");
        }
    }
    ,
    LT{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, "<");
        }
    }
    ,
    LE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, "<=");
        }
    }
    ,
    GT{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, ">");
        }
    }
    ,
    GE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeCondition(tableAlias, columnName, ">=");
        }
    }
    ,
    IN{

        @Override
        public boolean isTarget(Object value) {
            return this.isTargetForIn("in", value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForIn(tableAlias, columnName, "in", value);
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return this.addValueForIn(paramList, value);
        }
    }
    ,
    NOT_IN{

        @Override
        public boolean isTarget(Object value) {
            return this.isTargetForIn("not in", value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForIn(tableAlias, columnName, "not in", value);
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return this.addValueForIn(paramList, value);
        }
    }
    ,
    LIKE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", null);
        }
    }
    ,
    LIKE_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", "?");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            Object[] values = (Object[])Object[].class.cast(value);
            super.addValue(valueList, values[0]);
            super.addValue(valueList, values[1]);
            return 2;
        }
    }
    ,
    NOT_LIKE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", null);
        }
    }
    ,
    NOT_LIKE_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", "?");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            Object[] values = (Object[])Object[].class.cast(value);
            super.addValue(valueList, values[0]);
            super.addValue(valueList, values[1]);
            return 2;
        }
    }
    ,
    STARTS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    STARTS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    NOT_STARTS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    NOT_STARTS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    ENDS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    ENDS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    NOT_ENDS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    NOT_ENDS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    CONTAINS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    CONTAINS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    NOT_CONTAINS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", null);
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    NOT_CONTAINS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForLike(tableAlias, columnName, "not like", "'$'");
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    IS_NULL{

        @Override
        public boolean isTarget(Object value) {
            return this.isTargetForIsNull("is null", value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForIsNull(tableAlias, columnName, "is null");
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return 0;
        }
    }
    ,
    IS_NOT_NULL{

        @Override
        public boolean isTarget(Object value) {
            return this.isTargetForIsNull("is not null", value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeConditionForIsNull(tableAlias, columnName, "is not null");
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return 0;
        }
    };


    public static ConditionType getConditionType(String name) {
        if (NE.hasSuffix(name)) {
            return NE;
        }
        if (LT.hasSuffix(name)) {
            return LT;
        }
        if (LE.hasSuffix(name)) {
            return LE;
        }
        if (GT.hasSuffix(name)) {
            return GT;
        }
        if (GE.hasSuffix(name)) {
            return GE;
        }
        if (NOT_IN.hasSuffix(name)) {
            return NOT_IN;
        }
        if (IN.hasSuffix(name)) {
            return IN;
        }
        if (LIKE.hasSuffix(name)) {
            return LIKE;
        }
        if (STARTS.hasSuffix(name)) {
            return STARTS;
        }
        if (ENDS.hasSuffix(name)) {
            return ENDS;
        }
        if (CONTAINS.hasSuffix(name)) {
            return CONTAINS;
        }
        if (IS_NULL.hasSuffix(name)) {
            return IS_NULL;
        }
        if (IS_NOT_NULL.hasSuffix(name)) {
            return IS_NOT_NULL;
        }
        return EQ;
    }

    public String getSuffix() {
        return "_" + this.name();
    }

    public boolean hasSuffix(String name) {
        return name.endsWith(this.getSuffix());
    }

    public String removeSuffix(String s) {
        String suffix = this.getSuffix();
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - this.getSuffix().length());
        }
        return s;
    }

    public int addCondition(String name, Object value, WhereClause whereClause, List<Object> valueList) {
        return this.addCondition(null, name, value, whereClause, valueList);
    }

    public int addCondition(String tableAlias, String columnName, Object value, WhereClause whereClause, List<Object> valueList) {
        if (this.isTarget(value)) {
            whereClause.addAndSql(this.getCondition(tableAlias, columnName, value));
            return this.addValue(valueList, value);
        }
        return 0;
    }

    public boolean isTarget(Object value) {
        return value != null;
    }

    public String getCondition(String name, Object value) {
        return this.getCondition(null, name, value);
    }

    public abstract String getCondition(String var1, String var2, Object var3);

    public int addValue(List<Object> valueList, Object value) {
        valueList.add(value);
        return 1;
    }

    protected String makeCondition(String tableAlias, String columnName, String operator) {
        StringBuilder buf = new StringBuilder(32);
        if (!StringUtil.isEmpty((String)tableAlias)) {
            buf.append(tableAlias).append('.');
        }
        buf.append(columnName).append(' ').append(operator).append(" ?");
        return new String(buf);
    }

    protected boolean isTargetForIn(String conditionName, Object value) {
        Collection<Object> values = null;
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            values = Arrays.asList((Object[])value);
        } else if (value instanceof Collection) {
            values = (Collection)value;
        } else {
            throw new NonArrayInConditionRuntimeException(conditionName, value.getClass());
        }
        if (values.isEmpty()) {
            return false;
        }
        for (Object element : values) {
            if (element == null) continue;
            return true;
        }
        return false;
    }

    protected String makeConditionForIn(String tableAlias, String columnName, String conditionName, Object value) {
        int size = value instanceof Collection ? ((Collection)value).size() : Array.getLength(value);
        StringBuilder buf = new StringBuilder(30);
        if (!StringUtil.isEmpty((String)tableAlias)) {
            buf.append(tableAlias).append('.');
        }
        buf.append(columnName).append(' ').append(conditionName).append(" (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    protected int addValueForIn(List<Object> valueList, Object value) {
        List<Object> list = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
        valueList.addAll(list);
        return list.size();
    }

    protected String makeConditionForLike(String tableAlias, String columnName, String operator, String escape) {
        StringBuilder buf = new StringBuilder(32);
        if (!StringUtil.isEmpty((String)tableAlias)) {
            buf.append(tableAlias).append('.');
        }
        buf.append(columnName).append(' ').append(operator).append(" ?");
        if (escape != null) {
            buf.append(" escape ").append(escape);
        }
        return new String(buf);
    }

    protected boolean isTargetForIsNull(String conditionName, Object value) {
        if (value != null && value.getClass() != Boolean.class) {
            throw new NonBooleanIsNullConditionRuntimeException(conditionName, value.getClass());
        }
        return value != null && Boolean.TRUE.equals(value);
    }

    protected String makeConditionForIsNull(String tableAlias, String columnName, String operator) {
        StringBuilder buf = new StringBuilder(32);
        if (!StringUtil.isEmpty((String)tableAlias)) {
            buf.append(tableAlias).append('.');
        }
        buf.append(columnName).append(' ').append(operator);
        return new String(buf);
    }
}

