/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.IterationContext;
import org.seasar.extension.jdbc.exception.SNonUniqueResultException;
import org.seasar.extension.jdbc.handler.AbstractBeanResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanIterationResultSetHandler
extends AbstractBeanResultSetHandler {
    protected int limit;
    protected IterationCallback callback;

    public BeanIterationResultSetHandler(Class<?> beanClass, DbmsDialect dialect, String sql, int limit, IterationCallback callback) {
        super(beanClass, dialect, sql);
        this.limit = limit;
        this.callback = callback;
    }

    public Object handle(ResultSet rs) throws SQLException, SNonUniqueResultException {
        IterationContext iterationContext = new IterationContext();
        Object result = null;
        for (int i = 0; (this.limit <= 0 || i < this.limit) && rs.next(); ++i) {
            Object entity = this.createRow(rs, this.createPropertyTypes(rs.getMetaData()));
            result = this.callback.iterate(entity, iterationContext);
            if (!iterationContext.isExit()) continue;
            return result;
        }
        return result;
    }
}

