/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.id;

import javax.persistence.TableGenerator;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SqlLogger;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.exception.IdGenerationFailedRuntimeException;
import org.seasar.extension.jdbc.handler.ObjectResultSetHandler;
import org.seasar.extension.jdbc.id.AbstractPreAllocateIdGenerator;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.types.LongType;
import org.seasar.extension.tx.TransactionCallback;
import org.seasar.extension.tx.TransactionManagerAdapter;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;

public class TableIdGenerator
extends AbstractPreAllocateIdGenerator {
    public static final String DEFAULT_TABLE = "ID_GENERATOR";
    public static final String DEFAULT_PK_COLUMN_NAME = "PK";
    public static final String DEFAULT_VALUE_COLUMN_NAME = "VALUE";
    protected TableGenerator tableGenerator;
    protected String catalog;
    protected String schema;
    protected String table;
    protected String pkColumnName;
    protected String pkColumnValue;
    protected String valueColumnName;
    protected String updateSql;
    protected String selectSql;

    public TableIdGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta, TableGenerator tableGenerator) {
        super(entityMeta, propertyMeta, tableGenerator.allocationSize());
        this.tableGenerator = tableGenerator;
        this.catalog = this.getCatalog();
        this.schema = this.getSchema();
        this.table = this.getTable();
        this.pkColumnName = this.getPkColumnName();
        this.pkColumnValue = this.getPkColumnValue();
        this.valueColumnName = this.getValueColumnName();
        this.updateSql = this.createUpdateSql();
        this.selectSql = this.createSelectSql();
    }

    protected long getNewInitialValue(final JdbcManagerImplementor jdbcManager, SqlLogger sqlLogger) {
        try {
            TransactionManagerAdapter txAdapter = SingletonS2Container.getComponent(TransactionManagerAdapter.class);
            Object result = txAdapter.requiresNew(new TransactionCallback(){

                public Object execute(TransactionManagerAdapter adapter) throws Throwable {
                    return TableIdGenerator.this.updateIdTable(jdbcManager);
                }
            });
            return ((Number)Number.class.cast(result)).longValue() - this.allocationSize;
        }
        catch (IdGenerationFailedRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName(), t);
        }
    }

    protected Number updateIdTable(JdbcManagerImplementor jdbcManager) {
        DataSource ds = jdbcManager.getDataSource();
        BasicUpdateHandler updateHandler = new BasicUpdateHandler(ds, this.updateSql);
        int rows = updateHandler.execute(new Object[]{this.allocationSize, this.pkColumnValue});
        if (rows != 1) {
            throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName());
        }
        BasicSelectHandler selectHandler = new BasicSelectHandler(ds, this.selectSql, (ResultSetHandler)new ObjectResultSetHandler((ValueType)new LongType(), this.selectSql));
        Object result = selectHandler.execute(new Object[]{this.pkColumnValue}, new Class[]{String.class});
        if (result == null || !Number.class.isInstance(result)) {
            throw new IdGenerationFailedRuntimeException(this.entityMeta.getName(), this.propertyMeta.getName());
        }
        return (Number)Number.class.cast(result);
    }

    protected String getCatalog() {
        String catalog = this.tableGenerator.catalog();
        if (!StringUtil.isEmpty((String)catalog)) {
            return catalog;
        }
        return this.entityMeta.getTableMeta().getCatalog();
    }

    protected String getSchema() {
        String schema = this.tableGenerator.schema();
        if (!StringUtil.isEmpty((String)schema)) {
            return schema;
        }
        return this.entityMeta.getTableMeta().getSchema();
    }

    protected String getTable() {
        String table = this.tableGenerator.table();
        if (!StringUtil.isEmpty((String)table)) {
            return table;
        }
        return DEFAULT_TABLE;
    }

    protected String getPkColumnName() {
        String pkColumnName = this.tableGenerator.pkColumnName();
        if (!StringUtil.isEmpty((String)pkColumnName)) {
            return pkColumnName;
        }
        return DEFAULT_PK_COLUMN_NAME;
    }

    protected String getPkColumnValue() {
        String pkColumnValue = this.tableGenerator.pkColumnValue();
        if (!StringUtil.isEmpty((String)pkColumnValue)) {
            return pkColumnValue;
        }
        return this.entityMeta.getTableMeta().getName() + "_" + this.propertyMeta.getColumnMeta().getName();
    }

    protected String getValueColumnName() {
        String valueColumnName = this.tableGenerator.valueColumnName();
        if (!StringUtil.isEmpty((String)valueColumnName)) {
            return valueColumnName;
        }
        return DEFAULT_VALUE_COLUMN_NAME;
    }

    protected String createUpdateSql() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("update ");
        if (!StringUtil.isEmpty((String)this.catalog)) {
            buf.append(this.catalog).append('.');
        }
        if (!StringUtil.isEmpty((String)this.schema)) {
            buf.append(this.schema).append('.');
        }
        buf.append(this.table).append(" set ").append(this.valueColumnName).append(" = ").append(this.valueColumnName).append(" + ? where ").append(this.pkColumnName).append(" = ?");
        return new String(buf);
    }

    protected String createSelectSql() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("select ").append(this.valueColumnName).append(" from ");
        if (!StringUtil.isEmpty((String)this.catalog)) {
            buf.append(this.catalog).append('.');
        }
        if (!StringUtil.isEmpty((String)this.schema)) {
            buf.append(this.schema).append('.');
        }
        buf.append(this.table).append(" where ").append(this.pkColumnName).append(" = ?");
        return new String(buf);
    }
}

