/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.seasar.framework.autodetector.ClassAutoDetector;
import org.seasar.framework.autodetector.ResourceAutoDetector;
import org.seasar.framework.jpa.PersistenceUnitConfiguration;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitConfigurationImpl
implements PersistenceUnitConfiguration {
    protected PersistenceUnitManager persistenceUnitManager;
    protected Map<String, List<String>> mappingFiles = CollectionsUtil.newHashMap();
    protected Map<String, List<Class<?>>> persistenceClasses = CollectionsUtil.newHashMap();
    protected Map<String, List<ResourceAutoDetector>> mappingFileAutoDetectors = CollectionsUtil.newHashMap();
    protected Map<String, List<ClassAutoDetector>> persistenceClassAutoDetectors = CollectionsUtil.newHashMap();

    public void setPersistenceUnitManager(PersistenceUnitManager persistenceUnitManager) {
        this.persistenceUnitManager = persistenceUnitManager;
    }

    public void setMappingFileAutoDetector(ResourceAutoDetector[] detectors) {
        for (ResourceAutoDetector detector : detectors) {
            this.addMappingFileAutoDetector(detector);
        }
    }

    public void setPersistenceClassAutoDetector(ClassAutoDetector[] detectors) {
        for (ClassAutoDetector detector : detectors) {
            this.addPersistenceClassAutoDetector(detector);
        }
    }

    @Override
    public void addMappingFile(String fileName) {
        this.addMappingFile(null, fileName);
    }

    @Override
    public void addMappingFile(String unitName, String fileName) {
        if (!this.mappingFiles.containsKey(unitName)) {
            this.mappingFiles.put(unitName, new ArrayList());
        }
        this.mappingFiles.get(unitName).add(fileName);
    }

    @Override
    public void addPersistenceClass(Class<?> clazz) {
        this.addPersistenceClass(null, clazz);
    }

    @Override
    public void addPersistenceClass(String unitName, Class<?> clazz) {
        if (!this.persistenceClasses.containsKey(unitName)) {
            this.persistenceClasses.put(unitName, new ArrayList());
        }
        this.persistenceClasses.get(unitName).add(clazz);
    }

    @Override
    public void addMappingFileAutoDetector(ResourceAutoDetector detector) {
        this.addMappingFileAutoDetector(null, detector);
    }

    @Override
    public void addMappingFileAutoDetector(String unitName, ResourceAutoDetector detector) {
        if (!this.mappingFileAutoDetectors.containsKey(unitName)) {
            this.mappingFileAutoDetectors.put(unitName, new ArrayList());
        }
        this.mappingFileAutoDetectors.get(unitName).add(detector);
    }

    @Override
    public void addPersistenceClassAutoDetector(ClassAutoDetector detector) {
        this.addPersistenceClassAutoDetector(null, detector);
    }

    @Override
    public void addPersistenceClassAutoDetector(String unitName, ClassAutoDetector detector) {
        if (!this.persistenceClassAutoDetectors.containsKey(unitName)) {
            this.persistenceClassAutoDetectors.put(unitName, new ArrayList());
        }
        this.persistenceClassAutoDetectors.get(unitName).add(detector);
    }

    @Override
    public void detectMappingFiles(String unitName, ResourceTraversal.ResourceHandler handler) {
        for (String mappingFile : this.getMappingFileList(unitName)) {
            handler.processResource(mappingFile, null);
        }
        for (String mappingFile : this.getMappingFileList(null)) {
            if (!this.isTarget(unitName, mappingFile)) continue;
            handler.processResource(mappingFile, null);
        }
        for (ResourceAutoDetector detector : this.getMappingFileAutoDetectorList(unitName)) {
            detector.detect(handler);
        }
        for (ResourceAutoDetector detector : this.getMappingFileAutoDetectorList(null)) {
            detector.detect((ResourceTraversal.ResourceHandler)new UnitNameAwareHandler(unitName, handler));
        }
    }

    @Override
    public void detectPersistenceClasses(String unitName, ClassTraversal.ClassHandler handler) {
        for (Class<?> clazz : this.getPersistenceClassList(unitName)) {
            this.invokeHandler(handler, clazz);
        }
        for (Class<?> clazz : this.getPersistenceClassList(null)) {
            if (!this.isTarget(unitName, clazz)) continue;
            this.invokeHandler(handler, clazz);
        }
        for (ClassAutoDetector detector : this.getPersistenceClassAutoDetectorList(unitName)) {
            detector.detect(handler);
        }
        for (ClassAutoDetector detector : this.getPersistenceClassAutoDetectorList(null)) {
            detector.detect((ClassTraversal.ClassHandler)new UnitNameAwareHandler(unitName, handler));
        }
    }

    @Override
    public boolean isAutoDetection() {
        return this.persistenceClassAutoDetectors.size() > 0 || this.mappingFileAutoDetectors.size() > 0;
    }

    protected List<String> getMappingFileList(String unitName) {
        List<String> result = this.mappingFiles.get(unitName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected List<ResourceAutoDetector> getMappingFileAutoDetectorList(String unitName) {
        List<ResourceAutoDetector> result = this.mappingFileAutoDetectors.get(unitName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected List<Class<?>> getPersistenceClassList(String unitName) {
        List<Class<?>> result = this.persistenceClasses.get(unitName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected List<ClassAutoDetector> getPersistenceClassAutoDetectorList(String unitName) {
        List<ClassAutoDetector> result = this.persistenceClassAutoDetectors.get(unitName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    protected void invokeHandler(ClassTraversal.ClassHandler handler, Class<?> clazz) {
        handler.processClass(ClassUtil.getPackageName(clazz), ClassUtil.getShortClassName(clazz));
    }

    protected boolean isTarget(String unitName, String mappingFile) {
        return unitName.equals(this.persistenceUnitManager.getAbstractPersistenceUnitName(mappingFile));
    }

    protected boolean isTarget(String unitName, Class<?> clazz) {
        return unitName.equals(this.persistenceUnitManager.getAbstractPersistenceUnitName(clazz));
    }

    public class UnitNameAwareHandler
    implements ResourceTraversal.ResourceHandler,
    ClassTraversal.ClassHandler {
        protected String unitName;
        protected ResourceTraversal.ResourceHandler delegateResourceHandler;
        protected ClassTraversal.ClassHandler delegateClassHandler;

        public UnitNameAwareHandler(String unitName, ResourceTraversal.ResourceHandler delegateResourceHandler) {
            this.unitName = unitName;
            this.delegateResourceHandler = delegateResourceHandler;
        }

        public UnitNameAwareHandler(String unitName, ClassTraversal.ClassHandler delegateClassHandler) {
            this.unitName = unitName;
            this.delegateClassHandler = delegateClassHandler;
        }

        public void processResource(String path, InputStream is) {
            if (PersistenceUnitConfigurationImpl.this.isTarget(this.unitName, path)) {
                this.delegateResourceHandler.processResource(path, is);
            }
        }

        public void processClass(String packageName, String shortClassName) {
            String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
            Class clazz = ReflectionUtil.forName(className);
            if (PersistenceUnitConfigurationImpl.this.isTarget(this.unitName, clazz)) {
                this.delegateClassHandler.processClass(packageName, shortClassName);
            }
        }
    }
}

