/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientId;

public abstract class RecipientInformation {
    protected RecipientId rid = new RecipientId();
    protected AlgorithmIdentifier encAlg;
    protected AlgorithmIdentifier macAlg;
    protected AlgorithmIdentifier keyEncAlg;
    protected InputStream data;
    private MacInputStream macStream;
    private byte[] resultMac;

    protected RecipientInformation(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        this(algorithmIdentifier, null, algorithmIdentifier2, inputStream);
    }

    protected RecipientInformation(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3, InputStream inputStream) {
        this.encAlg = algorithmIdentifier;
        this.macAlg = algorithmIdentifier2;
        this.keyEncAlg = algorithmIdentifier3;
        this.data = inputStream;
    }

    public RecipientId getRID() {
        return this.rid;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }

    public String getKeyEncryptionAlgOID() {
        return this.keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this.keyEncAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        return this.getKeyEncryptionAlgorithmParameters(CMSUtils.getProvider(string));
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        try {
            byte[] byArray = this.encodeObj(this.keyEncAlg.getParameters());
            if (byArray == null) {
                return null;
            }
            AlgorithmParameters algorithmParameters = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(this.getKeyEncryptionAlgOID(), provider);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    protected CMSTypedStream getContentFromSessionKey(Key key, Provider provider) throws CMSException {
        try {
            if (this.encAlg != null) {
                String string = this.encAlg.getObjectId().getId();
                Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string, provider);
                ASN1Object aSN1Object = (ASN1Object)this.encAlg.getParameters();
                if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
                    try {
                        AlgorithmParameters algorithmParameters = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(string, cipher.getProvider());
                        algorithmParameters.init(aSN1Object.getEncoded(), "ASN.1");
                        cipher.init(2, key, algorithmParameters);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        if (string.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || string.equals("1.3.6.1.4.1.188.7.1.1.2") || string.equals(CMSEnvelopedDataGenerator.AES128_CBC) || string.equals(CMSEnvelopedDataGenerator.AES192_CBC) || string.equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
                            cipher.init(2, key, new IvParameterSpec(ASN1OctetString.getInstance((Object)aSN1Object).getOctets()));
                        }
                        throw noSuchAlgorithmException;
                    }
                } else if (string.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || string.equals("1.3.6.1.4.1.188.7.1.1.2") || string.equals("1.2.840.113533.7.66.10")) {
                    cipher.init(2, key, new IvParameterSpec(new byte[8]));
                } else {
                    cipher.init(2, key);
                }
                if (this.macAlg != null) {
                    return new CMSTypedStream(this.createMacStream(this.macAlg, key, new CipherInputStream(this.data, cipher), provider));
                }
                return new CMSTypedStream(new CipherInputStream(this.data, cipher));
            }
            return new CMSTypedStream(this.createMacStream(this.macAlg, key, this.data, provider));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("MAC algorithm parameter spec invalid.", invalidParameterSpecException);
        }
        catch (IOException iOException) {
            throw new CMSException("error decoding algorithm parameters.", iOException);
        }
    }

    private InputStream createMacStream(AlgorithmIdentifier algorithmIdentifier, Key key, InputStream inputStream, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IOException, InvalidParameterSpecException {
        Mac mac = CMSEnvelopedHelper.INSTANCE.getMac(algorithmIdentifier.getObjectId().getId(), provider);
        ASN1Object aSN1Object = (ASN1Object)algorithmIdentifier.getParameters();
        if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
            AlgorithmParameters algorithmParameters = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(algorithmIdentifier.getObjectId().getId(), provider);
            algorithmParameters.init(aSN1Object.getEncoded(), "ASN.1");
            mac.init(key, algorithmParameters.getParameterSpec(IvParameterSpec.class));
        } else {
            mac.init(key);
        }
        this.macStream = new MacInputStream(mac, inputStream);
        return this.macStream;
    }

    public byte[] getContent(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContent(key, CMSUtils.getProvider(string));
    }

    public byte[] getContent(Key key, Provider provider) throws CMSException {
        try {
            if (this.data instanceof ByteArrayInputStream) {
                this.data.reset();
            }
            return CMSUtils.streamToByteArray(this.getContentStream(key, provider).getContentStream());
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse internal stream: " + iOException);
        }
    }

    public byte[] getMac() {
        if (this.macStream != null && this.resultMac == null) {
            this.resultMac = this.macStream.getMac();
        }
        return this.resultMac;
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public abstract CMSTypedStream getContentStream(Key var1, Provider var2) throws CMSException;

    private class MacInputStream
    extends InputStream {
        private final InputStream inStream;
        private final Mac mac;

        MacInputStream(Mac mac, InputStream inputStream) {
            this.inStream = inputStream;
            this.mac = mac;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.inStream.read(byArray, n, n2);
            if (n3 > 0) {
                this.mac.update(byArray, n, n3);
            }
            return n3;
        }

        @Override
        public int read() throws IOException {
            int n = this.inStream.read();
            if (n > 0) {
                this.mac.update((byte)n);
            }
            return n;
        }

        public byte[] getMac() {
            return this.mac.doFinal();
        }
    }
}

