/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractorFactory;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOXMLParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, Map<String, Object> context) throws IOException, SAXException, TikaException {
        try {
            OOXMLExtractor extractor = OOXMLExtractorFactory.createExtractor((POIXMLTextExtractor)ExtractorFactory.createExtractor((InputStream)stream));
            extractor.getMetadataExtractor().extract(metadata);
            extractor.getXHTML(handler, metadata);
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
        catch (OpenXML4JException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
        catch (XmlException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Map<String, Object> context = Collections.emptyMap();
        this.parse(stream, handler, metadata, context);
    }
}

