/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.opendocument;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.opendocument.OpenOfficeContentParser;
import org.apache.tika.parser.opendocument.OpenOfficeMetaParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenOfficeParser
implements Parser {
    private Parser meta = new OpenOfficeMetaParser();
    private Parser content = new OpenOfficeContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, Map<String, Object> context) throws IOException, SAXException, TikaException {
        ZipInputStream zip = new ZipInputStream(stream);
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals("mimetype")) {
                String type = IOUtils.toString((InputStream)zip, (String)"UTF-8");
                metadata.set("Content-Type", type);
            } else if (entry.getName().equals("meta.xml")) {
                this.meta.parse((InputStream)zip, (ContentHandler)new DefaultHandler(), metadata, context);
            } else if (entry.getName().equals("content.xml")) {
                this.content.parse((InputStream)zip, handler, metadata, context);
            }
            entry = zip.getNextEntry();
        }
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        Map<String, Object> context = Collections.emptyMap();
        this.parse(stream, handler, metadata, context);
    }
}

