/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.seasar.dbflute.BehaviorSelector;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.BehaviorReadable;
import org.seasar.dbflute.bhv.ConditionBeanSetupper;
import org.seasar.dbflute.bhv.LoadReferrerOption;
import org.seasar.dbflute.bhv.batch.TokenFileOutputOption;
import org.seasar.dbflute.bhv.batch.TokenFileOutputResult;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.BehaviorCommandInvoker;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.bhv.core.command.AbstractSelectCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectCountCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectCursorCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectListCBCommand;
import org.seasar.dbflute.bhv.core.command.SelectNextValCommand;
import org.seasar.dbflute.bhv.core.command.SelectScalarCBCommand;
import org.seasar.dbflute.bhv.outsidesql.OutsideSqlBasicExecutor;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ConditionBeanContext;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingBean;
import org.seasar.dbflute.cbean.PagingHandler;
import org.seasar.dbflute.cbean.PagingInvoker;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.ResultBeanBuilder;
import org.seasar.dbflute.cbean.ScalarQuery;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.DangerousResultSizeException;
import org.seasar.dbflute.helper.token.file.FileMakingHeaderInfo;
import org.seasar.dbflute.helper.token.file.FileMakingOption;
import org.seasar.dbflute.helper.token.file.impl.FileMakingSimpleFacadeImpl;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorReadable
implements BehaviorReadable {
    protected BehaviorCommandInvoker _behaviorCommandInvoker;
    protected BehaviorSelector _behaviorSelector;

    protected abstract DBDef getCurrentDBDef();

    protected abstract StatementConfig getDefaultStatementConfig();

    @Override
    public int getCountAll() {
        return this.callGetCountAll();
    }

    @Override
    public int readCount(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.callReadCount(cb);
    }

    @Override
    public Entity readEntity(ConditionBean cb) {
        this.assertCBNotNull(cb);
        ListResultBean<Entity> ls = this.readList(cb);
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (Entity)ls.get(0);
    }

    @Override
    public Entity readEntityWithDeletedCheck(ConditionBean cb) {
        this.assertCBNotNull(cb);
        ListResultBean<Entity> ls = this.readList(cb);
        this.assertEntityNotDeleted(ls, (Object)cb);
        this.assertEntitySelectedAsOne(ls, cb);
        return (Entity)ls.get(0);
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityInternally(CB cb, InternalSelectEntityCallback<ENTITY, CB> callback) {
        this.assertCBNotNull(cb);
        cb.checkSafetyResult(1);
        List<ENTITY> ls = null;
        try {
            ls = callback.callbackSelectList(cb);
        }
        catch (DangerousResultSizeException e) {
            this.throwEntityDuplicatedException("{Over safetyMaxResultSize '1'}", cb, e);
        }
        if (ls.isEmpty()) {
            return null;
        }
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    protected <ENTITY extends Entity, CB extends ConditionBean> ENTITY helpSelectEntityWithDeletedCheckInternally(CB cb, InternalSelectEntityWithDeletedCheckCallback<ENTITY, CB> callback) {
        this.assertCBNotNull(cb);
        cb.checkSafetyResult(1);
        List<ENTITY> ls = null;
        try {
            ls = callback.callbackSelectList(cb);
        }
        catch (DangerousResultSizeException e) {
            this.throwEntityDuplicatedException("{Over safetyMaxResultSize '1'}", cb, e);
        }
        this.assertEntityNotDeleted(ls, cb);
        this.assertEntitySelectedAsOne(ls, cb);
        return (ENTITY)((Entity)ls.get(0));
    }

    @Override
    public ListResultBean<Entity> readList(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return new ResultBeanBuilder<Entity>(this.getTableDbName()).buildListResultBean(cb, this.callReadList(cb));
    }

    @Override
    public PagingResultBean<Entity> readPage(final ConditionBean cb) {
        this.assertCBNotNull(cb);
        PagingInvoker<Entity> invoker = new PagingInvoker<Entity>(this.getTableDbName());
        PagingHandler<Entity> handler = new PagingHandler<Entity>(){

            @Override
            public PagingBean getPagingBean() {
                return cb;
            }

            @Override
            public int count() {
                return AbstractBehaviorReadable.this.readCount(cb);
            }

            @Override
            public List<Entity> paging() {
                return AbstractBehaviorReadable.this.readList(cb);
            }
        };
        return invoker.invokePaging(handler);
    }

    protected void assertEntityNotDeleted(Entity entity, Object searchKey4Log) {
        if (entity == null) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
    }

    protected void assertEntityNotDeleted(List<? extends Entity> ls, Object searchKey4Log) {
        if (ls == null || ls.isEmpty()) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
    }

    protected void assertEntitySelectedAsOne(List<? extends Entity> ls, Object searchKey4Log) {
        if (ls == null || ls.isEmpty()) {
            this.throwEntityAlreadyDeletedException(searchKey4Log);
        }
        if (ls.size() > 1) {
            this.throwEntityDuplicatedException(ls.size() + "", searchKey4Log, null);
        }
    }

    private void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        ConditionBeanContext.throwEntityAlreadyDeletedException(searchKey4Log);
    }

    private void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        ConditionBeanContext.throwEntityDuplicatedException(resultCountString, searchKey4Log, cause);
    }

    public OutsideSqlBasicExecutor outsideSql() {
        this.assertBehaviorCommandInvoker("outsideSql");
        return new OutsideSqlBasicExecutor(this._behaviorCommandInvoker, this.getTableDbName(), this.getCurrentDBDef(), this.getDefaultStatementConfig());
    }

    @Override
    public BigDecimal readNextVal() {
        try {
            Method method = this.getClass().getMethod("selectNextVal", new Class[0]);
            Object sequenceObject = method.invoke((Object)this, new Object[0]);
            if (sequenceObject instanceof BigDecimal) {
                return (BigDecimal)sequenceObject;
            }
            return (BigDecimal)this.helpConvertingSequenceObject(BigDecimal.class, sequenceObject);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The table does not have sequence: " + this.getTableDbName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("The selectNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
    }

    protected Object helpConvertingSequenceObject(Class<?> resultClass, Object sequenceObject) {
        try {
            Constructor<?> constructor = resultClass.getConstructor(String.class);
            return constructor.newInstance(sequenceObject.toString());
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("The readNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
        try {
            Method method = resultClass.getMethod("valueOf", Long.TYPE);
            return method.invoke(null, Long.valueOf(sequenceObject.toString()));
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("The readNextVal() of the table threw the exception: " + this.getTableDbName(), e);
        }
        String msg = "Cannot convert sequenceObject to resultClass:";
        msg = msg + " resultClass=" + resultClass + " sequenceObjectType=" + sequenceObject.getClass();
        throw new IllegalStateException(msg);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void helpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        this.doHelpLoadReferrerInternally(localEntityList, loadReferrerOption, callback);
    }

    protected <LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> void doHelpLoadReferrerInternally(List<LOCAL_ENTITY> localEntityList, LoadReferrerOption<REFERRER_CB, REFERRER_ENTITY> loadReferrerOption, InternalLoadReferrerCallback<LOCAL_ENTITY, PK, REFERRER_CB, REFERRER_ENTITY> callback) {
        PK referrerListKey;
        this.assertBehaviorSelectorNotNull("loadReferrer");
        this.assertObjectNotNull("localEntityList", localEntityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
        if (localEntityList.isEmpty()) {
            return;
        }
        LinkedHashMap<PK, Entity> pkLocalEntityMap = new LinkedHashMap<PK, Entity>();
        ArrayList<PK> pkList = new ArrayList<PK>();
        for (Entity localEntity : localEntityList) {
            PK primaryKeyValue = callback.callbackBase_getPrimaryKeyValue(localEntity);
            pkList.add(callback.callbackBase_getPrimaryKeyValue(localEntity));
            pkLocalEntityMap.put(this.toLowerCasePrimaryKeyIfString(primaryKeyValue), localEntity);
        }
        REFERRER_CB cb = loadReferrerOption.getReferrerConditionBean() != null ? loadReferrerOption.getReferrerConditionBean() : callback.callbackReferrer_newMyConditionBean();
        callback.callbackReferrer_queryForeignKeyInScope(cb, pkList);
        loadReferrerOption.delegateKeyConditionExchangingFirstWhereClauseForLastOne(cb);
        if (!loadReferrerOption.isStopOrderByKey() && pkList.size() > 1) {
            callback.callbackReferrer_queryAddOrderByForeignKeyAsc(cb);
            cb.getSqlComponentOfOrderByClause().exchangeFirstOrderByElementForLastOne();
        }
        loadReferrerOption.delegateConditionBeanSettingUp(cb);
        List<REFERRER_ENTITY> referrerList = callback.callbackReferrer_selectList(cb);
        loadReferrerOption.delegateEntitySettingUp(referrerList);
        LinkedHashMap pkReferrerListMap = new LinkedHashMap();
        for (Entity referrerEntity : referrerList) {
            PK foreignKeyValue = callback.callbackReferrer_getForeignKeyValue(referrerEntity);
            referrerListKey = this.toLowerCasePrimaryKeyIfString(foreignKeyValue);
            if (!pkReferrerListMap.containsKey(referrerListKey)) {
                pkReferrerListMap.put(referrerListKey, new ArrayList());
            }
            ((List)pkReferrerListMap.get(referrerListKey)).add(referrerEntity);
            Entity localEntity = (Entity)pkLocalEntityMap.get(referrerListKey);
            callback.callbackReferrer_setForeignEntity(referrerEntity, localEntity);
        }
        for (Entity localEntity : localEntityList) {
            PK primaryKey = callback.callbackBase_getPrimaryKeyValue(localEntity);
            referrerListKey = this.toLowerCasePrimaryKeyIfString(primaryKey);
            if (pkReferrerListMap.containsKey(referrerListKey)) {
                callback.callbackBase_setReferrerList(localEntity, (List)pkReferrerListMap.get(referrerListKey));
                continue;
            }
            callback.callbackBase_setReferrerList(localEntity, new ArrayList());
        }
    }

    protected <PK> PK toLowerCasePrimaryKeyIfString(PK value) {
        return (PK)this.toLowerCaseIfString(value);
    }

    protected void xassLRArg(Entity entity, ConditionBeanSetupper<? extends ConditionBean> conditionBeanSetupper) {
        this.assertObjectNotNull("entity(" + this.getDBMeta().getEntityType().getSimpleName() + ")", entity);
        this.assertObjectNotNull("conditionBeanSetupper", conditionBeanSetupper);
    }

    protected void xassLRArg(List<? extends Entity> entityList, ConditionBeanSetupper<? extends ConditionBean> conditionBeanSetupper) {
        this.assertObjectNotNull("List<" + this.getDBMeta().getEntityType().getSimpleName() + ">", entityList);
        this.assertObjectNotNull("conditionBeanSetupper", conditionBeanSetupper);
    }

    protected void xassLRArg(Entity entity, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("entity(" + this.getDBMeta().getEntityType().getSimpleName() + ")", entity);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected void xassLRArg(List<? extends Entity> entityList, LoadReferrerOption<? extends ConditionBean, ? extends Entity> loadReferrerOption) {
        this.assertObjectNotNull("List<" + this.getDBMeta().getEntityType().getSimpleName() + ">", entityList);
        this.assertObjectNotNull("loadReferrerOption", loadReferrerOption);
    }

    protected BehaviorSelector xgetBSFLR() {
        this.assertBehaviorSelectorNotNull("loadReferrer");
        return this.getBehaviorSelector();
    }

    private void assertBehaviorSelectorNotNull(String methodName) {
        if (this._behaviorSelector == null) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "Not found the selector of behavior as behavior's attribute!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "Please confirm the definition of the selector at your component configuration of DBFlute." + this.getLineSeparator();
            msg = msg + "It is precondition that '" + methodName + "()' needs the selector instance." + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Your Behavior's Attributes]" + this.getLineSeparator();
            msg = msg + "  _behaviorCommandInvoker : " + this._behaviorCommandInvoker + this.getLineSeparator();
            msg = msg + "  _behaviorSelector       : " + this._behaviorSelector + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg);
        }
    }

    protected <ELEMENT> List<ELEMENT> xnewLRLs(ELEMENT element) {
        ArrayList<ELEMENT> ls = new ArrayList<ELEMENT>(1);
        ls.add(element);
        return ls;
    }

    protected <LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> List<FOREIGN_ENTITY> helpPulloutInternally(List<LOCAL_ENTITY> localEntityList, InternalPulloutCallback<LOCAL_ENTITY, FOREIGN_ENTITY> callback) {
        this.assertObjectNotNull("localEntityList", localEntityList);
        LinkedHashSet<FOREIGN_ENTITY> foreignSet = new LinkedHashSet<FOREIGN_ENTITY>();
        for (Entity entity : localEntityList) {
            FOREIGN_ENTITY foreignEntity = callback.callbackGetForeignEntity(entity);
            if (foreignEntity == null || foreignSet.contains(foreignEntity)) continue;
            foreignSet.add(foreignEntity);
        }
        return new ArrayList(foreignSet);
    }

    public TokenFileOutputExecutor tokenFileOutput() {
        return new TokenFileOutputExecutor();
    }

    protected int callGetCountAll() {
        return this.callReadCount(this.newConditionBean());
    }

    protected List<Entity> callGetListAll() {
        return this.callReadList(this.newConditionBean());
    }

    protected int callReadCount(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.doCallReadCount(cb);
    }

    protected abstract int doCallReadCount(ConditionBean var1);

    protected List<Entity> callReadList(ConditionBean cb) {
        this.assertCBNotNull(cb);
        return this.doCallReadList(cb);
    }

    protected abstract List<Entity> doCallReadList(ConditionBean var1);

    protected void filterEntityOfInsert(Entity targetEntity) {
    }

    @Override
    public void warmUpCommand() {
        AbstractSelectCBCommand cmd = this.createSelectCountCBCommand(this.newConditionBean());
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
        cmd = this.createSelectListCBCommand(this.newConditionBean(), this.getDBMeta().getEntityType());
        cmd.setInitializeOnly(true);
        this.invoke(cmd);
    }

    protected SelectCountCBCommand createSelectCountCBCommand(ConditionBean cb) {
        this.assertBehaviorCommandInvoker("createSelectCountCBCommand");
        SelectCountCBCommand command = this.xsetupSelectCommand(new SelectCountCBCommand());
        command.setConditionBeanType(cb.getClass());
        command.setConditionBean(cb);
        return command;
    }

    protected <ENTITY extends Entity> SelectCursorCBCommand<ENTITY> createSelectCursorCBCommand(ConditionBean cb, EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectCursorCBCommand");
        SelectCursorCBCommand<ENTITY> command = this.xsetupSelectCommand(new SelectCursorCBCommand());
        command.setConditionBeanType(cb.getClass());
        command.setConditionBean(cb);
        command.setEntityType(entityType);
        command.setEntityRowHandler(entityRowHandler);
        return command;
    }

    protected <ENTITY extends Entity> SelectListCBCommand<ENTITY> createSelectListCBCommand(ConditionBean cb, Class<ENTITY> entityType) {
        this.assertBehaviorCommandInvoker("createSelectListCBCommand");
        SelectListCBCommand<ENTITY> command = this.xsetupSelectCommand(new SelectListCBCommand());
        command.setConditionBeanType(cb.getClass());
        command.setConditionBean(cb);
        command.setEntityType(entityType);
        return command;
    }

    protected <RESULT> SelectNextValCommand<RESULT> createSelectNextValCommand(Class<RESULT> resultType) {
        this.assertBehaviorCommandInvoker("createSelectNextValCommand");
        SelectNextValCommand<RESULT> command = this.xsetupSelectCommand(new SelectNextValCommand());
        command.setResultType(resultType);
        command.setDBMeta(this.getDBMeta());
        return command;
    }

    protected <RESULT> SelectScalarCBCommand<RESULT> createSelectScalarCBCommand(ConditionBean cb, Class<RESULT> resultType, SqlClause.SelectClauseType selectClauseType) {
        this.assertBehaviorCommandInvoker("createSelectScalarCBCommand");
        SelectScalarCBCommand<RESULT> command = this.xsetupSelectCommand(new SelectScalarCBCommand());
        command.setConditionBeanType(cb.getClass());
        command.setConditionBean(cb);
        command.setResultType(resultType);
        command.setSelectClauseType(selectClauseType);
        return command;
    }

    private <COMMAND extends AbstractBehaviorCommand<?>> COMMAND xsetupSelectCommand(COMMAND command) {
        command.setTableDbName(this.getTableDbName());
        this._behaviorCommandInvoker.injectComponentProperty(command);
        return command;
    }

    protected <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        return this._behaviorCommandInvoker.invoke(behaviorCommand);
    }

    protected void assertBehaviorCommandInvoker(String methodName) {
        if (this._behaviorCommandInvoker == null) {
            String msg = "Look! Read the message below." + this.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = msg + "Not found the invoker of behavior command as behavior's attributed!" + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Advice]" + this.getLineSeparator();
            msg = msg + "Please confirm the definition of the invoker at your 'dbflute.dicon'." + this.getLineSeparator();
            msg = msg + "It is precondition that '" + methodName + "()' needs the invoker instance." + this.getLineSeparator();
            msg = msg + this.getLineSeparator();
            msg = msg + "[Your Behavior's Attributes]" + this.getLineSeparator();
            msg = msg + "  _behaviorCommandInvoker : " + this._behaviorCommandInvoker + this.getLineSeparator();
            msg = msg + "  _behaviorSelector       : " + this._behaviorSelector + this.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new IllegalStateException(msg);
        }
    }

    protected abstract boolean hasVersionNoValue(Entity var1);

    protected abstract boolean hasUpdateDateValue(Entity var1);

    protected Object toLowerCaseIfString(Object obj) {
        if (obj != null && obj instanceof String) {
            return ((String)obj).toLowerCase();
        }
        return obj;
    }

    protected String getLineSeparator() {
        return DfSystemUtil.getLineSeparator();
    }

    protected <ENTITY extends Entity> ENTITY helpDowncastInternally(Entity entity, Class<ENTITY> clazz) {
        this.assertObjectNotNull("entity", entity);
        this.assertObjectNotNull("clazz", clazz);
        try {
            return (ENTITY)entity;
        }
        catch (ClassCastException e) {
            String msg = "The entity should be " + clazz.getSimpleName() + " but it was: " + entity.getClass();
            throw new RuntimeException(msg, e);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertEntityNotNull(Entity entity) {
        this.assertObjectNotNull("entity", entity);
    }

    protected void assertConditionBeanNotNull(ConditionBean cb) {
        this.assertCBNotNull(cb);
    }

    protected void assertCBNotNull(ConditionBean cb) {
        this.assertObjectNotNull("cb", cb);
    }

    protected void assertEntityNotNullAndHasPrimaryKeyValue(Entity entity) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            String msg = "The entity must should primary-key: entity=" + entity;
            throw new IllegalArgumentException(msg + entity);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (!ls.isEmpty()) {
            String msg = "The list should be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndNotEmpty(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.isEmpty()) {
            String msg = "The list should not be empty: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertListNotNullAndHasOnlyOne(List<?> ls) {
        this.assertObjectNotNull("ls", ls);
        if (ls.size() != 1) {
            String msg = "The list should contain only one object: ls=" + ls.toString();
            throw new IllegalArgumentException(msg);
        }
    }

    protected BehaviorCommandInvoker getBehaviorCommandInvoker() {
        return this._behaviorCommandInvoker;
    }

    public void setBehaviorCommandInvoker(BehaviorCommandInvoker behaviorCommandInvoker) {
        this._behaviorCommandInvoker = behaviorCommandInvoker;
    }

    protected BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    public class TokenFileOutputExecutor {
        public TokenFileOutputResult outputTokenFile(ConditionBean cb, String filename, TokenFileOutputOption tokenFileOutputOption) throws FileNotFoundException, IOException {
            AbstractBehaviorReadable.this.assertCBNotNull(cb);
            AbstractBehaviorReadable.this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
            AbstractBehaviorReadable.this.assertObjectNotNull("tokenFileOutputOption", tokenFileOutputOption);
            ListResultBean<Entity> ls = AbstractBehaviorReadable.this.readList(cb);
            ArrayList<List<String>> rowList = new ArrayList<List<String>>();
            for (Entity entity : ls) {
                List<String> valueList = AbstractBehaviorReadable.this.getDBMeta().convertToColumnStringValueList(entity);
                rowList.add(valueList);
            }
            FileMakingSimpleFacadeImpl fileMakingSimpleFacade = new FileMakingSimpleFacadeImpl();
            FileMakingOption fileMakingOption = tokenFileOutputOption.getFileMakingOption();
            FileMakingHeaderInfo fileMakingHeaderInfo = new FileMakingHeaderInfo();
            ArrayList<String> columnDbNameList = new ArrayList<String>();
            for (ColumnInfo columnInfo : AbstractBehaviorReadable.this.getDBMeta().getColumnInfoList()) {
                columnDbNameList.add(columnInfo.getColumnDbName());
            }
            fileMakingHeaderInfo.setColumnNameList(columnDbNameList);
            fileMakingOption.setFileMakingHeaderInfo(fileMakingHeaderInfo);
            fileMakingSimpleFacade.makeFromRowList(filename, rowList, fileMakingOption);
            TokenFileOutputResult tokeFileOutputResult = new TokenFileOutputResult();
            tokeFileOutputResult.setSelectedList(ls);
            return tokeFileOutputResult;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalPulloutCallback<LOCAL_ENTITY extends Entity, FOREIGN_ENTITY extends Entity> {
        public FOREIGN_ENTITY callbackGetForeignEntity(LOCAL_ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalLoadReferrerCallback<LOCAL_ENTITY extends Entity, PK, REFERRER_CB extends ConditionBean, REFERRER_ENTITY extends Entity> {
        public PK callbackBase_getPrimaryKeyValue(LOCAL_ENTITY var1);

        public void callbackBase_setReferrerList(LOCAL_ENTITY var1, List<REFERRER_ENTITY> var2);

        public REFERRER_CB callbackReferrer_newMyConditionBean();

        public void callbackReferrer_queryForeignKeyInScope(REFERRER_CB var1, List<PK> var2);

        public void callbackReferrer_queryAddOrderByForeignKeyAsc(REFERRER_CB var1);

        public List<REFERRER_ENTITY> callbackReferrer_selectList(REFERRER_CB var1);

        public PK callbackReferrer_getForeignKeyValue(REFERRER_ENTITY var1);

        public void callbackReferrer_setForeignEntity(REFERRER_ENTITY var1, LOCAL_ENTITY var2);
    }

    public static class ScalarSelectInvalidColumnSpecificationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScalarSelectInvalidColumnSpecificationException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SLFunction<CB extends ConditionBean, RESULT> {
        protected CB _conditionBean;
        protected Class<RESULT> _resultType;
        final /* synthetic */ AbstractBehaviorReadable this$0;

        public SLFunction(CB conditionBean, Class<RESULT> resultType) {
            this.this$0 = var1_1;
            this._conditionBean = conditionBean;
            this._resultType = resultType;
        }

        public RESULT max(ScalarQuery<CB> scalarQuery) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MAX);
        }

        public RESULT min(ScalarQuery<CB> scalarQuery) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.MIN);
        }

        public RESULT sum(ScalarQuery<CB> scalarQuery) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.SUM);
        }

        public RESULT avg(ScalarQuery<CB> scalarQuery) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            return this.exec(scalarQuery, SqlClause.SelectClauseType.AVG);
        }

        protected RESULT exec(ScalarQuery<CB> scalarQuery, SqlClause.SelectClauseType selectClauseType) {
            this.this$0.assertObjectNotNull("scalarQuery", scalarQuery);
            this.this$0.assertObjectNotNull("selectClauseType", (Object)selectClauseType);
            this.this$0.assertObjectNotNull("conditionBean", this._conditionBean);
            this.this$0.assertObjectNotNull("resultType", this._resultType);
            scalarQuery.query(this._conditionBean);
            this.assertScalarSelectRequiredSpecifyColumn();
            return this.this$0.invoke(this.this$0.createSelectScalarCBCommand((ConditionBean)this._conditionBean, this._resultType, selectClauseType));
        }

        protected void assertScalarSelectRequiredSpecifyColumn() {
            String columnName = this._conditionBean.getSqlClause().getSpecifiedColumnNameAsOne();
            if (columnName == null) {
                this.throwScalarSelectInvalidColumnSpecificationException();
            }
        }

        protected void throwScalarSelectInvalidColumnSpecificationException() {
            String msg = "Look! Read the message below." + this.this$0.getLineSeparator();
            msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.this$0.getLineSeparator();
            msg = msg + "The specified column for scalar select was Invalid!" + this.this$0.getLineSeparator();
            msg = msg + this.this$0.getLineSeparator();
            msg = msg + "[Advice]" + this.this$0.getLineSeparator();
            msg = msg + " You should call specify().column[TargetColumn]() only once." + this.this$0.getLineSeparator();
            msg = msg + "  For example:" + this.this$0.getLineSeparator();
            msg = msg + "    " + this.this$0.getLineSeparator();
            msg = msg + "    [Wrong]" + this.this$0.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.this$0.getLineSeparator();
            msg = msg + "    memberBhv.scalarSelect(Date.class).max(new ScalarQuery<MemberCB>() {" + this.this$0.getLineSeparator();
            msg = msg + "        public void query(MemberCB cb) {" + this.this$0.getLineSeparator();
            msg = msg + "            // *No! It's empty!" + this.this$0.getLineSeparator();
            msg = msg + "        }" + this.this$0.getLineSeparator();
            msg = msg + "    });" + this.this$0.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.this$0.getLineSeparator();
            msg = msg + "    " + this.this$0.getLineSeparator();
            msg = msg + "    [Wrong]" + this.this$0.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.this$0.getLineSeparator();
            msg = msg + "    memberBhv.scalarSelect(Date.class).max(new ScalarQuery<MemberCB>() {" + this.this$0.getLineSeparator();
            msg = msg + "        public void query(MemberCB cb) {" + this.this$0.getLineSeparator();
            msg = msg + "            cb.specify().columnMemberBirthday();" + this.this$0.getLineSeparator();
            msg = msg + "            cb.specify().columnRegisterDatetime(); // *No! It's duplicated!" + this.this$0.getLineSeparator();
            msg = msg + "        }" + this.this$0.getLineSeparator();
            msg = msg + "    });" + this.this$0.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.this$0.getLineSeparator();
            msg = msg + "    " + this.this$0.getLineSeparator();
            msg = msg + "    [Good!]" + this.this$0.getLineSeparator();
            msg = msg + "    /- - - - - - - - - - - - - - - - - - - - " + this.this$0.getLineSeparator();
            msg = msg + "    memberBhv.scalarSelect(Date.class).max(new ScalarQuery<MemberCB>() {" + this.this$0.getLineSeparator();
            msg = msg + "        public void query(MemberCB cb) {" + this.this$0.getLineSeparator();
            msg = msg + "            cb.specify().columnMemberBirthday(); // *Point!" + this.this$0.getLineSeparator();
            msg = msg + "        }" + this.this$0.getLineSeparator();
            msg = msg + "    });" + this.this$0.getLineSeparator();
            msg = msg + "    - - - - - - - - - -/" + this.this$0.getLineSeparator();
            msg = msg + this.this$0.getLineSeparator();
            msg = msg + "[ConditionBean Type]" + this.this$0.getLineSeparator() + this._conditionBean.getClass().getName() + this.this$0.getLineSeparator();
            msg = msg + this.this$0.getLineSeparator();
            msg = msg + "[Result Type]" + this.this$0.getLineSeparator() + this._resultType.getName() + this.this$0.getLineSeparator();
            msg = msg + "* * * * * * * * * */";
            throw new ScalarSelectInvalidColumnSpecificationException(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityWithDeletedCheckCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalSelectEntityCallback<ENTITY extends Entity, CB extends ConditionBean> {
        public List<ENTITY> callbackSelectList(CB var1);
    }
}

