/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.sqlclause.OrderByClause;
import org.seasar.dbflute.util.DfSystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String _aliasName;
    protected String _columnName;
    protected String _registeredAliasName;
    protected String _registeredColumnName;
    protected String _ascDesc = "asc";
    protected transient OrderByClause.OrderByNullsSetupper _orderByNullsSetupper;
    protected boolean _nullsFirst;
    protected transient OrderByClause.ManumalOrderInfo _manualOrderInfo;

    public void setupAsc() {
        this._ascDesc = "asc";
    }

    public void setupDesc() {
        this._ascDesc = "desc";
    }

    public void reverse() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._ascDesc.equals("asc")) {
            this._ascDesc = "desc";
        } else if (this._ascDesc.equals("desc")) {
            this._ascDesc = "asc";
        } else {
            String msg = "The attribute[ascDesc] should be asc or desc: but ascDesc=" + this._ascDesc;
            throw new IllegalStateException(msg);
        }
    }

    public boolean isAsc() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._ascDesc.equals("asc")) {
            return true;
        }
        if (this._ascDesc.equals("desc")) {
            return false;
        }
        String msg = "The attribute[ascDesc] should be asc or desc: but ascDesc=" + this._ascDesc;
        throw new IllegalStateException(msg);
    }

    public String getColumnFullName() {
        StringBuilder sb = new StringBuilder();
        if (this._aliasName != null) {
            sb.append(this._aliasName).append(".");
        }
        if (this._columnName == null) {
            String msg = "The attribute[columnName] should not be null.";
            throw new IllegalStateException(msg);
        }
        sb.append(this._columnName);
        return sb.toString();
    }

    public String getElementClause() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        StringBuilder sb = new StringBuilder();
        if (this._manualOrderInfo != null && this._manualOrderInfo.hasManualValueList()) {
            this.setupManualOrderClause(sb, this.getColumnFullName());
            return sb.toString();
        }
        sb.append(this.getColumnFullName()).append(" ").append(this._ascDesc);
        if (this._orderByNullsSetupper != null) {
            return this._orderByNullsSetupper.setup(this.getColumnFullName(), sb.toString(), this._nullsFirst);
        }
        return sb.toString();
    }

    public String getElementClause(Map<String, String> selectClauseRealColumnAliasMap) {
        if (selectClauseRealColumnAliasMap == null) {
            String msg = "The argument[selectClauseRealColumnAliasMap] should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        String columnAlias = selectClauseRealColumnAliasMap.get(this.getColumnFullName());
        if (columnAlias == null || columnAlias.trim().length() == 0) {
            this.throwOrderByColumnNotFoundException(this.getColumnFullName(), selectClauseRealColumnAliasMap);
        }
        StringBuilder sb = new StringBuilder();
        if (this._manualOrderInfo != null && this._manualOrderInfo.hasManualValueList()) {
            this.setupManualOrderClause(sb, columnAlias);
            return sb.toString();
        }
        sb.append(columnAlias).append(" ").append(this._ascDesc);
        if (this._orderByNullsSetupper != null) {
            return this._orderByNullsSetupper.setup(columnAlias, sb.toString(), this._nullsFirst);
        }
        return sb.toString();
    }

    protected void setupManualOrderClause(StringBuilder sb, String columnAlias) {
        List<? extends Object> manualValueList = this._manualOrderInfo.getManualValueList();
        sb.append(this.ln()).append("   case").append(this.ln());
        int index = 0;
        for (Object object : manualValueList) {
            String q = object instanceof Number ? "" : "'";
            sb.append("     when ");
            if (object != null) {
                sb.append(columnAlias).append(" = ").append(q).append(object).append(q);
                sb.append(" then ").append(index).append(this.ln());
            }
            ++index;
        }
        sb.append("     else ").append(index).append(this.ln());
        sb.append("   end ").append(this._ascDesc);
    }

    protected void throwOrderByColumnNotFoundException(String columnName, Map<String, String> selectClauseRealColumnAliasMap) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The column for order-by was Not Found in select-clause!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "If you use 'union()' or 'unionAll()', Check your condition-bean!" + this.ln();
        msg = msg + "Order-by for union can use only columns on select-clause." + this.ln();
        msg = msg + "So the rule when using union is little difference from the one when NOT using." + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    [before (x)]" + this.ln();
        msg = msg + "    AaaCB cb = new AaaCB();" + this.ln();
        msg = msg + "    cb.query().setXxx...();" + this.ln();
        msg = msg + "    cb.union(new UnionQuery<AaaCB>() {" + this.ln();
        msg = msg + "        public void query(AaaCB unionCB) {" + this.ln();
        msg = msg + "            unionCB.query().setXxx...();" + this.ln();
        msg = msg + "        }" + this.ln();
        msg = msg + "    }" + this.ln();
        msg = msg + "    cb.query().queryBbb().addOrderBy_BbbName_Asc();// *NG!" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "    [after (o)]" + this.ln();
        msg = msg + "    AaaCB cb = new AaaCB();" + this.ln();
        msg = msg + "    cb.setupSelect_Bbb();// *Point!" + this.ln();
        msg = msg + "    cb.query().setXxx...();" + this.ln();
        msg = msg + "    cb.union(new UnionQuery<AaaCB>() {" + this.ln();
        msg = msg + "        public void query(AaaCB unionCB) {" + this.ln();
        msg = msg + "            unionCB.query().setXxx...();" + this.ln();
        msg = msg + "        }" + this.ln();
        msg = msg + "    }" + this.ln();
        msg = msg + "    cb.query().queryBbb().addOrderBy_BbbName_Asc();// *OK!" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "Or else if you DON'T use 'union()' or 'unionAll()', This is the Framework Exception!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Column]" + this.ln();
        msg = msg + columnName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Internal Object]" + this.ln();
        msg = msg + "selectClauseRealColumnAliasMap=" + selectClauseRealColumnAliasMap + this.ln();
        msg = msg + "* * * * * * * * * */" + this.ln();
        throw new IllegalStateException(msg);
    }

    protected String ln() {
        return DfSystemUtil.getLineSeparator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{aliasName=").append(this._aliasName);
        sb.append(" columnName=").append(this._columnName);
        sb.append(" registeredAliasName=").append(this._registeredAliasName);
        sb.append(" registeredColumnName=").append(this._registeredColumnName);
        sb.append(" ascDesc=").append(this._ascDesc).append("}");
        return sb.toString();
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public String getRegisteredAliasName() {
        return this._registeredAliasName;
    }

    public String getRegisteredColumnName() {
        return this._registeredColumnName;
    }

    public String getAscDesc() {
        return this._ascDesc;
    }

    public void setAliasName(String value) {
        this._aliasName = value;
    }

    public void setColumnName(String value) {
        this._columnName = value;
    }

    public void setRegisteredAliasName(String value) {
        this._registeredAliasName = value;
    }

    public void setRegisteredColumnName(String value) {
        this._registeredColumnName = value;
    }

    public void setAscDesc(String value) {
        this._ascDesc = value;
    }

    public void setOrderByNullsSetupper(OrderByClause.OrderByNullsSetupper value, boolean nullsFirst) {
        this._orderByNullsSetupper = value;
        this._nullsFirst = nullsFirst;
    }

    public void setManumalOrderInfo(OrderByClause.ManumalOrderInfo manualOrderInfo) {
        this._manualOrderInfo = manualOrderInfo;
    }
}

