/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.helper.stacktrace.impl;

import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractingResource;
import org.seasar.dbflute.helper.stacktrace.InvokeNameExtractor;
import org.seasar.dbflute.helper.stacktrace.InvokeNameResult;

public class InvokeNameExtractorImpl
implements InvokeNameExtractor {
    protected StackTraceElement[] _stackTrace;

    public InvokeNameResult extractInvokeName(InvokeNameExtractingResource resource) {
        if (this._stackTrace == null) {
            String msg = "The attribute 'stackTrace' should not be null: resource=" + resource;
            throw new IllegalStateException(msg);
        }
        String targetSimpleClassName = null;
        String targetMethodName = null;
        int lineNumber = 0;
        int foundIndex = -1;
        int foundFirstIndex = -1;
        boolean onTarget = false;
        for (int i = resource.getStartIndex(); i < this._stackTrace.length; ++i) {
            StackTraceElement element = this._stackTrace[i];
            if (i > resource.getStartIndex() + resource.getLoopSize()) break;
            String className = element.getClassName();
            if (className.startsWith("sun.") || className.startsWith("java.")) {
                if (!onTarget) continue;
                break;
            }
            String methodName = element.getMethodName();
            if (resource.isTargetElement(className, methodName)) {
                if (methodName.equals("invoke")) continue;
                targetSimpleClassName = className.substring(className.lastIndexOf(".") + 1);
                targetMethodName = methodName;
                if (resource.isUseAdditionalInfo()) {
                    lineNumber = element.getLineNumber();
                }
                foundIndex = i;
                if (foundFirstIndex == -1) {
                    foundFirstIndex = i;
                }
                onTarget = true;
                continue;
            }
            if (onTarget) break;
        }
        InvokeNameResult result = new InvokeNameResult();
        if (targetSimpleClassName == null) {
            result.beEmptyResult();
            return result;
        }
        String filteredClassName = resource.filterSimpleClassName(targetSimpleClassName);
        result.setSimpleClassName(resource.filterSimpleClassName(targetSimpleClassName));
        result.setMethodName(targetMethodName);
        if (lineNumber > 0) {
            result.setInvokeName(filteredClassName + "." + targetMethodName + "():" + lineNumber + " --> ");
        } else {
            result.setInvokeName(filteredClassName + "." + targetMethodName + "() --> ");
        }
        result.setFoundIndex(foundIndex);
        result.setFoundFirstIndex(foundFirstIndex);
        return result;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this._stackTrace = stackTrace;
    }
}

