/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.seasar.dbflute.helper.StringKeyMap;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.exception.TnConstructorNotFoundRuntimeException;
import org.seasar.dbflute.s2dao.beans.exception.TnFieldNotFoundRuntimeException;
import org.seasar.dbflute.s2dao.beans.exception.TnMethodNotFoundRuntimeException;
import org.seasar.dbflute.s2dao.beans.exception.TnPropertyNotFoundRuntimeException;
import org.seasar.dbflute.s2dao.beans.impl.TnPropertyDescImpl;
import org.seasar.dbflute.util.DfReflectionUtil;
import org.seasar.dbflute.util.DfStringUtil;
import org.seasar.dbflute.util.DfTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TnBeanDescImpl
implements TnBeanDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class<?>[] EMPTY_PARAM_TYPES = new Class[0];
    private Class<?> beanClass;
    private Constructor<?>[] constructors;
    private StringKeyMap<TnPropertyDesc> propertyDescMap = StringKeyMap.createAsCaseInsensitive();
    private Map<String, Method[]> methodsMap = new ConcurrentHashMap<String, Method[]>();
    private Map<String, Field> fieldMap = new ConcurrentHashMap<String, Field>();
    private transient Set<String> invalidPropertyNames = new HashSet<String>();

    public TnBeanDescImpl(Class<?> beanClass) {
        if (beanClass == null) {
            String msg = "The argument 'beanClass' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this.beanClass = beanClass;
        this.constructors = beanClass.getConstructors();
        this.setupPropertyDescs();
        this.setupMethods();
        this.setupFields();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Constructor<?> getSuitableConstructor(Object[] args) throws TnConstructorNotFoundRuntimeException {
        Constructor<?> constructor;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((constructor = this.findSuitableConstructor(args)) != null) {
            return constructor;
        }
        constructor = this.findSuitableConstructorAdjustNumber(args);
        if (constructor != null) {
            return constructor;
        }
        throw new TnConstructorNotFoundRuntimeException(this.beanClass, args);
    }

    @Override
    public Constructor<?> getConstructor(Class<?>[] paramTypes) {
        for (int i = 0; i < this.constructors.length; ++i) {
            if (!Arrays.equals(paramTypes, this.constructors[i].getParameterTypes())) continue;
            return this.constructors[i];
        }
        throw new TnConstructorNotFoundRuntimeException(this.beanClass, paramTypes);
    }

    @Override
    public boolean hasPropertyDesc(String propertyName) {
        return this.getPropertyDescInternally(propertyName) != null;
    }

    @Override
    public TnPropertyDesc getPropertyDesc(String propertyName) throws TnPropertyNotFoundRuntimeException {
        TnPropertyDesc pd = this.getPropertyDescInternally(propertyName);
        if (pd == null) {
            throw new TnPropertyNotFoundRuntimeException(this.beanClass, propertyName);
        }
        return pd;
    }

    private TnPropertyDesc getPropertyDescInternally(String propertyName) {
        return this.propertyDescMap.get(propertyName);
    }

    @Override
    public int getPropertyDescSize() {
        return this.propertyDescMap.size();
    }

    @Override
    public List<String> getProppertyNameList() {
        return new ArrayList<String>(this.propertyDescMap.keySet());
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fieldMap.get(fieldName) != null;
    }

    @Override
    public Field getField(String fieldName) {
        Field field = this.fieldMap.get(fieldName);
        if (field == null) {
            throw new TnFieldNotFoundRuntimeException(this.beanClass, fieldName);
        }
        return field;
    }

    @Override
    public int getFieldSize() {
        return this.fieldMap.size();
    }

    @Override
    public Method getMethod(String methodName) {
        return this.getMethod(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethodNoException(String methodName) {
        return this.getMethodNoException(methodName, EMPTY_PARAM_TYPES);
    }

    @Override
    public Method getMethod(String methodName, Class<?>[] paramTypes) {
        Method method = this.getMethodNoException(methodName, paramTypes);
        if (method != null) {
            return method;
        }
        throw new TnMethodNotFoundRuntimeException(this.beanClass, methodName, paramTypes);
    }

    @Override
    public Method getMethodNoException(String methodName, Class<?>[] paramTypes) {
        Method[] methods = this.methodsMap.get(methodName);
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!Arrays.equals(paramTypes, methods[i].getParameterTypes())) continue;
            return methods[i];
        }
        return null;
    }

    @Override
    public Method[] getMethods(String methodName) throws TnMethodNotFoundRuntimeException {
        Method[] methods = this.methodsMap.get(methodName);
        if (methods == null) {
            throw new TnMethodNotFoundRuntimeException(this.beanClass, methodName, null);
        }
        return methods;
    }

    @Override
    public boolean hasMethod(String methodName) {
        return this.methodsMap.get(methodName) != null;
    }

    @Override
    public String[] getMethodNames() {
        return this.methodsMap.keySet().toArray(new String[this.methodsMap.size()]);
    }

    @Override
    public Object newInstance(Object[] args) throws TnConstructorNotFoundRuntimeException {
        Constructor<?> constructor = this.getSuitableConstructor(args);
        return DfReflectionUtil.newInstance(constructor, args);
    }

    @Override
    public Object getFieldValue(String fieldName, Object target) throws TnFieldNotFoundRuntimeException {
        Field field = this.getField(fieldName);
        return DfReflectionUtil.getValue(field, target);
    }

    @Override
    public Object invoke(Object target, String methodName, Object[] args) {
        Method method = this.getSuitableMethod(methodName, args);
        return DfReflectionUtil.invoke(method, target, args);
    }

    private Constructor<?> findSuitableConstructor(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class<?>[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !DfReflectionUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private Constructor<?> findSuitableConstructorAdjustNumber(Object[] args) {
        block0: for (int i = 0; i < this.constructors.length; ++i) {
            Class<?>[] paramTypes = this.constructors[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !DfReflectionUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !TnBeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return this.constructors[i];
        }
        return null;
    }

    private static boolean adjustNumber(Class<?>[] paramTypes, Object[] args, int index) {
        if (paramTypes[index].isPrimitive()) {
            if (paramTypes[index] == Integer.TYPE) {
                args[index] = DfTypeUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.TYPE) {
                args[index] = DfTypeUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.TYPE) {
                args[index] = DfTypeUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.TYPE) {
                args[index] = DfTypeUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.TYPE) {
                args[index] = DfTypeUtil.toFloat(args[index]);
                return true;
            }
        } else {
            if (paramTypes[index] == Integer.class) {
                args[index] = DfTypeUtil.toInteger(args[index]);
                return true;
            }
            if (paramTypes[index] == Double.class) {
                args[index] = DfTypeUtil.toDouble(args[index]);
                return true;
            }
            if (paramTypes[index] == Long.class) {
                args[index] = DfTypeUtil.toLong(args[index]);
                return true;
            }
            if (paramTypes[index] == Short.class) {
                args[index] = DfTypeUtil.toShort(args[index]);
                return true;
            }
            if (paramTypes[index] == Float.class) {
                args[index] = DfTypeUtil.toFloat(args[index]);
                return true;
            }
        }
        return false;
    }

    private void setupPropertyDescs() {
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String propertyName;
            Method m = methods[i];
            if (DfReflectionUtil.isBridgeMethod(m) || DfReflectionUtil.isSyntheticMethod(m)) continue;
            String methodName = m.getName();
            if (methodName.startsWith("get")) {
                if (m.getParameterTypes().length != 0 || methodName.equals("getClass") || m.getReturnType() == Void.TYPE) continue;
                propertyName = TnBeanDescImpl.decapitalizePropertyName(methodName.substring(3));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (methodName.startsWith("is")) {
                if (m.getParameterTypes().length != 0 || !m.getReturnType().equals(Boolean.TYPE) && !m.getReturnType().equals(Boolean.class)) continue;
                propertyName = TnBeanDescImpl.decapitalizePropertyName(methodName.substring(2));
                this.setupReadMethod(m, propertyName);
                continue;
            }
            if (!methodName.startsWith("set") || m.getParameterTypes().length != 1 || methodName.equals("setClass") || m.getReturnType() != Void.TYPE) continue;
            propertyName = TnBeanDescImpl.decapitalizePropertyName(methodName.substring(3));
            this.setupWriteMethod(m, propertyName);
        }
        Iterator<String> i = this.invalidPropertyNames.iterator();
        while (i.hasNext()) {
            this.propertyDescMap.remove(i.next());
        }
        this.invalidPropertyNames.clear();
    }

    private static String decapitalizePropertyName(String name) {
        if (DfStringUtil.isEmpty(name)) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private void addPropertyDesc(TnPropertyDesc propertyDesc) {
        if (propertyDesc == null) {
            String msg = "The argument 'propertyDesc' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this.propertyDescMap.put(propertyDesc.getPropertyName(), propertyDesc);
    }

    private void setupReadMethod(Method readMethod, String propertyName) {
        Class<?> propertyType = readMethod.getReturnType();
        TnPropertyDesc propDesc = this.getPropertyDescInternally(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setReadMethod(readMethod);
            }
        } else {
            propDesc = new TnPropertyDescImpl(propertyName, propertyType, readMethod, null, null, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private void setupWriteMethod(Method writeMethod, String propertyName) {
        Class<?> propertyType = writeMethod.getParameterTypes()[0];
        TnPropertyDesc propDesc = this.getPropertyDescInternally(propertyName);
        if (propDesc != null) {
            if (!propDesc.getPropertyType().equals(propertyType)) {
                this.invalidPropertyNames.add(propertyName);
            } else {
                propDesc.setWriteMethod(writeMethod);
            }
        } else {
            propDesc = new TnPropertyDescImpl(propertyName, propertyType, null, writeMethod, null, this);
            this.addPropertyDesc(propDesc);
        }
    }

    private Method getSuitableMethod(String methodName, Object[] args) throws TnMethodNotFoundRuntimeException {
        Method[] methods;
        Method method;
        if (args == null) {
            args = EMPTY_ARGS;
        }
        if ((method = this.findSuitableMethod(methods = this.getMethods(methodName), args)) != null) {
            return method;
        }
        method = this.findSuitableMethodAdjustNumber(methods, args);
        if (method != null) {
            return method;
        }
        throw new TnMethodNotFoundRuntimeException(this.beanClass, methodName, args);
    }

    private Method findSuitableMethod(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !DfReflectionUtil.isAssignableFrom(paramTypes[j], args[j].getClass())) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private Method findSuitableMethodAdjustNumber(Method[] methods, Object[] args) {
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != args.length) continue;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] != null && !DfReflectionUtil.isAssignableFrom(paramTypes[j], args[j].getClass()) && !TnBeanDescImpl.adjustNumber(paramTypes, args, j)) continue block0;
            }
            return methods[i];
        }
        return null;
    }

    private void setupMethods() {
        LinkedHashMap<String, ArrayList<Method>> methodListMap = new LinkedHashMap<String, ArrayList<Method>>();
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method)) continue;
            String methodName = method.getName();
            ArrayList<Method> list = (ArrayList<Method>)methodListMap.get(methodName);
            if (list == null) {
                list = new ArrayList<Method>();
                methodListMap.put(methodName, list);
            }
            list.add(method);
        }
        Set entrySet = methodListMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            List methodList = (List)entry.getValue();
            this.methodsMap.put(key, methodList.toArray(new Method[methodList.size()]));
        }
    }

    private void setupFields() {
        this.setupFields(this.beanClass);
    }

    private void setupFields(Class<?> targetClass) {
        if (targetClass.isInterface()) {
            this.setupFieldsByInterface(targetClass);
        } else {
            this.setupFieldsByClass(targetClass);
        }
    }

    private void setupFieldsByInterface(Class<?> interfaceClass) {
        this.addFields(interfaceClass);
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
    }

    private void addFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            TnPropertyDesc pd;
            Field field = fields[i];
            String fname = field.getName();
            if (this.fieldMap.containsKey(fname)) continue;
            field.setAccessible(true);
            this.fieldMap.put(fname, field);
            if (!DfReflectionUtil.isInstanceField(field)) continue;
            if (this.hasPropertyDesc(fname)) {
                pd = this.getPropertyDesc(field.getName());
                pd.setField(field);
                continue;
            }
            if (!DfReflectionUtil.isPublicField(field)) continue;
            pd = new TnPropertyDescImpl(field.getName(), field.getType(), null, null, field, this);
            this.propertyDescMap.put(fname, pd);
        }
    }

    private void setupFieldsByClass(Class<?> targetClass) {
        this.addFields(targetClass);
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.setupFieldsByInterface(interfaces[i]);
        }
        Class<?> superClass = targetClass.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            this.setupFieldsByClass(superClass);
        }
    }
}

