/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.cbean.FetchNarrowingBean;
import org.seasar.dbflute.exception.DangerousResultSizeException;
import org.seasar.dbflute.jdbc.ResultSetWrapper;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.resource.SQLExceptionHandler;

public class TnPagingResultSet
extends ResultSetWrapper {
    protected ResultSet _resultSet;
    protected FetchNarrowingBean _fetchNarrowingBean;
    protected long _fetchCounter;
    protected long _requestCounter;
    protected boolean _offsetByCursorForcedly;
    protected boolean _limitByCursorForcedly;
    protected boolean _skipToCursorEnd;
    protected final boolean _db2 = ResourceContext.isCurrentDBDef(DBDef.DB2);

    public TnPagingResultSet(ResultSet resultSet, FetchNarrowingBean fetchNarrowingBean, boolean offsetByCursorForcedly, boolean limitByCursorForcedly) {
        super(resultSet);
        this._resultSet = resultSet;
        this._fetchNarrowingBean = fetchNarrowingBean;
        this._offsetByCursorForcedly = offsetByCursorForcedly;
        this._limitByCursorForcedly = limitByCursorForcedly;
        this.skip();
    }

    protected void skip() {
        if (!this.isAvailableSkipRecord()) {
            return;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        if (this.isScrollableCursor()) {
            try {
                if (0 == skipStartIndex) {
                    this._resultSet.beforeFirst();
                } else {
                    this._resultSet.absolute(skipStartIndex);
                }
                this._fetchCounter = this._resultSet.getRow();
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        } else {
            try {
                while (this._fetchCounter < (long)skipStartIndex) {
                    if (!this._resultSet.next()) {
                        this._skipToCursorEnd = true;
                        break;
                    }
                    ++this._fetchCounter;
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        }
    }

    protected boolean isAvailableSkipRecord() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isOffsetByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingSkipStartIndexEffective();
    }

    public boolean next() throws SQLException {
        if (this._db2 && this._skipToCursorEnd) {
            return false;
        }
        boolean hasNext = super.next();
        ++this._requestCounter;
        if (!this.isAvailableLimitLoopCount()) {
            this.checkSafetyResult(hasNext);
            return hasNext;
        }
        if (hasNext && this._fetchCounter < (long)(this.getFetchNarrowingSkipStartIndex() + this.getFetchNarrowingLoopCount())) {
            ++this._fetchCounter;
            this.checkSafetyResult(true);
            return true;
        }
        return false;
    }

    protected boolean isAvailableLimitLoopCount() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isLimitByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingLoopCountEffective();
    }

    protected void checkSafetyResult(boolean hasNext) {
        if (hasNext && this.getSafetyMaxResultSize() > 0 && this._requestCounter > (long)(this.getSafetyMaxResultSize() + 1)) {
            String msg = "You have already been in Danger Zone!";
            msg = msg + " Please confirm your query or data of table: safetyMaxResultSize=" + this.getSafetyMaxResultSize();
            throw new DangerousResultSizeException(msg, this.getSafetyMaxResultSize());
        }
    }

    protected boolean isFetchNarrowingEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingEffective();
    }

    protected boolean isFetchNarrowingSkipStartIndexEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingSkipStartIndexEffective();
    }

    protected boolean isFetchNarrowingLoopCountEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingLoopCountEffective();
    }

    protected int getFetchNarrowingSkipStartIndex() {
        return this._fetchNarrowingBean.getFetchNarrowingSkipStartIndex();
    }

    protected int getFetchNarrowingLoopCount() {
        return this._fetchNarrowingBean.getFetchNarrowingLoopCount();
    }

    public int getSafetyMaxResultSize() {
        return this._fetchNarrowingBean.getSafetyMaxResultSize();
    }

    protected boolean isScrollableCursor() {
        try {
            return this._resultSet.getType() != 1003;
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return false;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new SQLExceptionHandler().handleSQLException(e, statement);
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public boolean isSkipToCursorEnd() {
        return this._skipToCursorEnd;
    }
}

