/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.s2dao.beans.TnBeanDesc;
import org.seasar.dbflute.s2dao.beans.TnPropertyDesc;
import org.seasar.dbflute.s2dao.beans.factory.TnBeanDescFactory;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.impl.TnPropertyTypeImpl;
import org.seasar.dbflute.s2dao.valuetype.TnValueTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TnAbstractPropertyTypeFactory
implements TnPropertyTypeFactory {
    protected Class<?> beanClass;
    protected TnBeanAnnotationReader beanAnnotationReader;
    protected TnValueTypeFactory valueTypeFactory;

    public TnAbstractPropertyTypeFactory(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader, TnValueTypeFactory valueTypeFactory) {
        this.beanClass = beanClass;
        this.beanAnnotationReader = beanAnnotationReader;
        this.valueTypeFactory = valueTypeFactory;
    }

    @Override
    public TnPropertyType[] createDtoPropertyTypes() {
        ArrayList<TnPropertyType> list = new ArrayList<TnPropertyType>();
        TnBeanDesc beanDesc = this.getBeanDesc();
        List<String> proppertyNameList = beanDesc.getProppertyNameList();
        for (String proppertyName : proppertyNameList) {
            TnPropertyDesc pd = beanDesc.getPropertyDesc(proppertyName);
            TnPropertyType pt = this.createPropertyType(pd);
            list.add(pt);
        }
        return list.toArray(new TnPropertyType[list.size()]);
    }

    protected TnBeanDesc getBeanDesc() {
        return TnBeanDescFactory.getBeanDesc(this.beanClass);
    }

    protected boolean isRelation(TnPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.hasRelationNo(propertyDesc);
    }

    protected boolean isPrimaryKey(TnPropertyDesc propertyDesc) {
        return this.beanAnnotationReader.getId(propertyDesc) != null;
    }

    protected abstract boolean isPersistent(TnPropertyType var1);

    protected TnPropertyType createPropertyType(TnPropertyDesc propertyDesc) {
        String columnName = this.getColumnName(propertyDesc);
        ValueType valueType = this.getValueType(propertyDesc);
        return new TnPropertyTypeImpl(propertyDesc, valueType, columnName);
    }

    protected String getColumnName(TnPropertyDesc propertyDesc) {
        String propertyName = propertyDesc.getPropertyName();
        String name = this.beanAnnotationReader.getColumnAnnotation(propertyDesc);
        return name != null ? name : propertyName;
    }

    protected ValueType getValueType(TnPropertyDesc propertyDesc) {
        String name = this.beanAnnotationReader.getValueType(propertyDesc);
        if (name != null) {
            return this.valueTypeFactory.getValueTypeByName(name);
        }
        Class<?> type = propertyDesc.getPropertyType();
        return this.valueTypeFactory.getValueTypeByClass(type);
    }
}

