/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfResourceUtil {
    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        extension = "." + extension;
        if (path.endsWith(extension)) {
            return path;
        }
        return path.replace('.', '/') + extension;
    }

    public static String getResourcePath(Class<?> clazz) {
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL getResourceUrl(String path) {
        return DfResourceUtil.getResourceUrl(path, null);
    }

    public static URL getResourceUrl(String path, String extension) {
        return DfResourceUtil.getResourceUrl(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceUrl(String path, String extension, ClassLoader loader) {
        if (path == null || loader == null) {
            return null;
        }
        path = DfResourceUtil.getResourcePath(path, extension);
        return loader.getResource(path);
    }

    public static String getFileName(URL url) {
        String s = url.getFile();
        return DfResourceUtil.decodeURL(s, "UTF8");
    }

    public static InputStream openStream(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            String msg = "Failed to open the stream: url=" + url;
            throw new IllegalStateException(msg, e);
        }
    }

    public static URLConnection openConnection(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL createURL(String spec) {
        try {
            return new URL(spec);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URL create(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decodeURL(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void makeFileAndClose(URL url, String outputFilename) {
        InputStream in;
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            String msg = url.getClass().getSimpleName() + "#openStream() threw the IO exception!";
            throw new IllegalStateException(msg, e);
        }
        DfResourceUtil.makeFileAndClose(in, outputFilename);
    }

    public static InputStream getResourceStream(String path) {
        return DfResourceUtil.getResourceStream(path, null);
    }

    public static InputStream getResourceStream(String path, String extension) {
        URL url = DfResourceUtil.getResourceUrl(path, extension);
        return url != null ? DfResourceUtil.openStream(url) : null;
    }

    public static boolean isExist(String path) {
        return DfResourceUtil.getResourceUrl(path) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(Reader reader) {
        BufferedReader in = new BufferedReader(reader);
        StringBuilder out = new StringBuilder(100);
        try {
            try {
                int n;
                char[] buf = new char[8192];
                while ((n = in.read(buf)) >= 0) {
                    out.append(buf, 0, n);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            String msg = "The IOException occurred: reader=" + reader;
            throw new IllegalStateException(msg, e);
        }
        return out.toString();
    }

    public static File getBuildDir(Class<?> clazz) {
        return DfResourceUtil.getBuildDir(DfResourceUtil.getResourcePath(clazz));
    }

    public static File getBuildDir(String path) {
        File dir = null;
        URL url = DfResourceUtil.getResourceUrl(path);
        if ("file".equals(url.getProtocol())) {
            int num = path.split("/").length;
            dir = new File(DfResourceUtil.getFileName(url));
            int i = 0;
            while (i < num) {
                ++i;
                dir = dir.getParentFile();
            }
        } else {
            dir = new File(DfResourceUtil.toJarFilePath(url));
        }
        return dir;
    }

    public static void makeFileAndClose(InputStream in, String outputFilename) {
        FileOutputStream fileOutputStream;
        byte[] bytes = DfResourceUtil.toBytesAndClose(in);
        File outputFile = new File(outputFilename);
        try {
            fileOutputStream = new FileOutputStream(outputFile, false);
        }
        catch (FileNotFoundException e) {
            String msg = "new FileOutputStream(outputFile, false) threw the " + e.getClass().getSimpleName();
            msg = msg + ": outputFilename=" + outputFilename;
            throw new IllegalStateException(msg, e);
        }
        try {
            fileOutputStream.write(bytes);
        }
        catch (IOException e) {
            String msg = "fileOutputStream.write(toBytes) threw the " + e.getClass().getSimpleName();
            msg = msg + ": outputFilename=" + outputFilename;
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException ignored) {}
        }
    }

    public static final byte[] toBytesAndClose(InputStream is) {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (is != null) {
                DfResourceUtil.close(is);
            }
        }
        return bytes;
    }

    public static void close(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void copy(InputStream is, OutputStream os) {
        byte[] buf = new byte[8192];
        try {
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static int available(InputStream is) {
        try {
            return is.available();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JarFile create(String file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JarFile create(File file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InputStream getInputStream(JarFile file, ZipEntry entry) {
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static JarFile toJarFile(URL jarUrl) {
        URLConnection con = DfResourceUtil.openConnection(jarUrl);
        if (con instanceof JarURLConnection) {
            return DfResourceUtil.getJarFile((JarURLConnection)con);
        }
        return DfResourceUtil.create(new File(DfResourceUtil.toJarFilePath(jarUrl)));
    }

    public static String toJarFilePath(URL jarUrl) {
        URL nestedUrl = DfResourceUtil.createURL(jarUrl.getPath());
        String nestedUrlPath = nestedUrl.getPath();
        int pos = nestedUrlPath.lastIndexOf(33);
        String jarFilePath = nestedUrlPath.substring(0, pos);
        File jarFile = new File(DfResourceUtil.decodeURL(jarFilePath, "UTF8"));
        return DfResourceUtil.getCanonicalPath(jarFile);
    }

    public static JarFile getJarFile(JarURLConnection conn) {
        try {
            return conn.getJarFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void close(JarFile jarFile) {
        try {
            jarFile.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

