/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.TableReader;
import org.seasar.extension.dataset.impl.DataRowReloadResultSetHandler;
import org.seasar.extension.dataset.impl.DataTableImpl;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;

public class SqlReloadTableReader
implements TableReader {
    private DataSource dataSource;
    private DataTable table;
    private String sql;
    private String[] primaryKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlReloadTableReader(DataSource dataSource, DataTable table) {
        this.dataSource = dataSource;
        this.table = table;
        Connection con = DataSourceUtil.getConnection(dataSource);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData(con);
            table.setupMetaData(dbMetaData);
        }
        finally {
            ConnectionUtil.close(con);
        }
        this.setup();
    }

    private void setup() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("SELECT ");
        StringBuffer whereBuf = new StringBuffer(100);
        whereBuf.append(" WHERE");
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        for (int i = 0; i < this.table.getColumnSize(); ++i) {
            DataColumn column = this.table.getColumn(i);
            buf.append(column.getColumnName());
            buf.append(", ");
            if (!column.isPrimaryKey()) continue;
            whereBuf.append(" ");
            whereBuf.append(column.getColumnName());
            whereBuf.append(" = ? AND");
            primaryKeyList.add(column.getColumnName());
        }
        buf.setLength(buf.length() - 2);
        whereBuf.setLength(whereBuf.length() - 4);
        buf.append(" FROM ");
        buf.append(this.table.getTableName());
        buf.append(whereBuf);
        this.sql = buf.toString();
        this.primaryKeys = primaryKeyList.toArray(new String[primaryKeyList.size()]);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataTable getTable() {
        return this.table;
    }

    public DataTable read() {
        int i;
        DataTableImpl newTable = new DataTableImpl(this.table.getTableName());
        for (i = 0; i < this.table.getColumnSize(); ++i) {
            DataColumn column = this.table.getColumn(i);
            newTable.addColumn(column.getColumnName(), column.getColumnType());
        }
        for (i = 0; i < this.table.getRowSize(); ++i) {
            DataRow row = this.table.getRow(i);
            DataRow newRow = newTable.addRow();
            this.reload(row, newRow);
        }
        return newTable;
    }

    protected void reload(DataRow row, DataRow newRow) {
        BasicSelectHandler selectHandler = new BasicSelectHandler(this.dataSource, this.sql, new DataRowReloadResultSetHandler(newRow));
        Object[] args = new Object[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            args[i] = row.getValue(this.primaryKeys[i]);
        }
        selectHandler.execute(args);
    }
}

